"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSettingsView = void 0;
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _ = require("..");
var _alert_selection = require("../alert_selection");
var _kibana = require("../../../../common/lib/kibana");
var _kuery = require("../../../../common/lib/kuery");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _parse_filter_query = require("../parse_filter_query");
var _containers = require("../../../../sourcerer/containers");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/hooks/use_settings_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useSettingsView = ({
  connectorId,
  onConnectorIdSelected,
  onGenerate,
  onSettingsReset,
  onSettingsSave,
  onSettingsChanged,
  settings,
  showConnectorSelector
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const filterManager = (0, _react2.useRef)(new _public.FilterManager(uiSettings));
  const {
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)();
  const [alertSummaryStackBy0, setAlertSummaryStackBy0] = (0, _react2.useState)(_.DEFAULT_STACK_BY_FIELD);
  const [alertsPreviewStackBy0, setAlertsPreviewStackBy0] = (0, _react2.useState)(_.DEFAULT_STACK_BY_FIELD);
  const [localConnectorId, setLocalConnectorId] = (0, _react2.useState)(connectorId);

  // Sync local connector ID with prop changes
  (0, _react2.useEffect)(() => {
    setLocalConnectorId(connectorId);
  }, [connectorId]);
  const handleLocalConnectorIdChange = (0, _react2.useCallback)(newConnectorId => {
    setLocalConnectorId(newConnectorId);
  }, []);
  const settingsView = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_alert_selection.AlertSelection, {
    alertsPreviewStackBy0: alertsPreviewStackBy0,
    alertSummaryStackBy0: alertSummaryStackBy0,
    connectorId: localConnectorId,
    filterManager: filterManager.current,
    onConnectorIdSelected: handleLocalConnectorIdChange,
    onSettingsChanged: onSettingsChanged,
    setAlertsPreviewStackBy0: setAlertsPreviewStackBy0,
    setAlertSummaryStackBy0: setAlertSummaryStackBy0,
    settings: settings,
    showConnectorSelector: showConnectorSelector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), [alertSummaryStackBy0, alertsPreviewStackBy0, localConnectorId, handleLocalConnectorIdChange, onSettingsChanged, settings, showConnectorSelector]);
  (0, _react2.useEffect)(() => {
    let isSubscribed = true;

    // init the Filter manager with the local filters:
    filterManager.current.setFilters(settings.filters);

    // subscribe to filter updates:
    const subscription = filterManager.current.getUpdates$().subscribe({
      next: () => {
        if (isSubscribed) {
          const newFilters = filterManager.current.getFilters();
          onSettingsChanged === null || onSettingsChanged === void 0 ? void 0 : onSettingsChanged({
            ...settings,
            filters: newFilters
          });
        }
      }
    });
    return () => {
      isSubscribed = false;
      subscription.unsubscribe();
    };
  }, [onSettingsChanged, settings]);
  const handleSave = (0, _react2.useCallback)(() => {
    if (localConnectorId && localConnectorId !== connectorId) {
      onConnectorIdSelected(localConnectorId);
    }
    onSettingsSave === null || onSettingsSave === void 0 ? void 0 : onSettingsSave();
  }, [connectorId, localConnectorId, onConnectorIdSelected, onSettingsSave]);
  const onSaveAndRun = (0, _react2.useCallback)(() => {
    handleSave();

    // Convert settings to filter query for overrides
    const [filterQuery, kqlError] = (0, _kuery.convertToBuildEsQuery)({
      config: (0, _common.getEsQueryConfig)(uiSettings),
      dataViewSpec: oldSourcererDataView,
      dataView: experimentalDataView,
      queries: [settings.query],
      filters: settings.filters
    });
    const overrideFilter = (0, _parse_filter_query.parseFilterQuery)({
      filterQuery,
      kqlError
    });

    // Pass the localConnectorId and settings overrides to ensure we use the selected values
    onGenerate === null || onGenerate === void 0 ? void 0 : onGenerate({
      overrideConnectorId: localConnectorId,
      overrideEnd: settings.end,
      overrideFilter,
      overrideSize: settings.size,
      overrideStart: settings.start
    });
  }, [experimentalDataView, handleSave, localConnectorId, oldSourcererDataView, onGenerate, settings.end, settings.filters, settings.query, settings.size, settings.start, uiSettings]);
  const actionButtons = (0, _react2.useMemo)(() => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      css: (0, _react.css)`
          gap: 16px;
        `,
      gutterSize: "none",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      css: (0, _react.css)`
            margin-right: ${euiTheme.size.s};
          `,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "reset",
      flush: "both",
      onClick: onSettingsReset,
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 11
      }
    }, i18n.RESET)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: localConnectorId == null ? i18n.SELECT_A_CONNECTOR_TO_SAVE : undefined,
      position: "top",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      color: "primary",
      css: (0, _react.css)`
                min-inline-size: 80px;
                width: 80px;
              `,
      "data-test-subj": "save",
      isDisabled: localConnectorId == null,
      onClick: handleSave,
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 13
      }
    }, i18n.SAVE))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: localConnectorId == null ? i18n.SELECT_A_CONNECTOR_TO_SAVE_AND_RUN : undefined,
      position: "top",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      "data-test-subj": "saveAndRun",
      isDisabled: localConnectorId == null,
      fill: true,
      iconType: "play",
      onClick: onSaveAndRun,
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 13
      }
    }, i18n.SAVE_AND_RUN))));
  }, [euiTheme.size.s, handleSave, localConnectorId, onSaveAndRun, onSettingsReset]);
  return {
    settingsView,
    actionButtons
  };
};
exports.useSettingsView = useSettingsView;