"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleView = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_find_schedules = require("../schedule/logic/use_find_schedules");
var _empty_page = require("../schedule/empty_page");
var _create_button = require("../schedule/create_button");
var _schedules_table = require("../schedule/schedules_table");
var _create_flyout = require("../schedule/create_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/hooks/use_schedule_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useScheduleView = () => {
  // showing / hiding the flyout:
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const openFlyout = (0, _react.useCallback)(() => setShowFlyout(true), []);
  const onClose = (0, _react.useCallback)(() => setShowFlyout(false), []);

  // TODO: add separate hook to fetch schedules stats/count
  const {
    data: {
      total
    } = {
      total: 0
    },
    isLoading: isDataLoading
  } = (0, _use_find_schedules.useFindAttackDiscoverySchedules)({
    disableToast: false
  });
  const scheduleView = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
      isLoading: isDataLoading,
      loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 15
        }
      })),
      loadedContent: !total ? /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 35
        }
      }) : /*#__PURE__*/_react.default.createElement(_schedules_table.SchedulesTable, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 51
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }), showFlyout && /*#__PURE__*/_react.default.createElement(_create_flyout.CreateFlyout, {
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 24
      }
    }));
  }, [isDataLoading, onClose, showFlyout, total]);
  const actionButtons = (0, _react.useMemo)(() => {
    return total ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_create_button.CreateButton, {
      onClick: openFlyout,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }))) : null;
  }, [openFlyout, total]);
  return {
    scheduleView,
    actionButtons
  };
};
exports.useScheduleView = useScheduleView;