"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Failure = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/empty_states/failure/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FailureComponent = ({
  failureReason
}) => {
  const Failures = (0, _react2.useMemo)(() => {
    const failures = failureReason != null ? failureReason.split('\n') : '';
    const [firstFailure, ...restFailures] = failures;
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }, firstFailure), restFailures.length > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
      id: "failuresFccordion",
      buttonContent: i18n.DETAILS,
      "data-test-subj": "failuresAccordion",
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, restFailures.map((failure, i) => /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
      fontSize: "m",
      key: i,
      paddingSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 17
      }
    }, failure)))));
  }, [failureReason]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "failure",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptContainer",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    body: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      color: "subdued",
      css: (0, _react.css)`
                word-wrap: break-word;
              `,
      "data-test-subj": "bodyText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }, Failures),
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      "data-test-subj": "failureTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 18
      }
    }, i18n.FAILURE_TITLE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    external: true,
    "data-test-subj": "learnMoreLink",
    href: "https://www.elastic.co/guide/en/security/current/attack-discovery.html",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, i18n.LEARN_MORE)));
};
const Failure = exports.Failure = /*#__PURE__*/_react2.default.memo(FailureComponent);