"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Actions = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _run = require("../run");
var _schedule = require("../schedule");
var _settings = require("../settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/header/actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ActionsComponent = ({
  isLoading,
  onGenerate,
  openFlyout,
  isDisabled
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const runSettingsGroup = (0, _react.css)`
    display: flex;
    gap: 1px;
  `;
  const scheduleSettingsSpacing = (0, _react.css)`
    margin-left: ${euiTheme.size.s};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "actions",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: runSettingsGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_run.Run, {
    isLoading: isLoading,
    isDisabled: isDisabled,
    onGenerate: onGenerate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_settings.Settings, {
    isLoading: isLoading,
    openFlyout: openFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: scheduleSettingsSpacing,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_schedule.Schedule, {
    isLoading: isLoading,
    openFlyout: openFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })));
};
ActionsComponent.displayName = 'Actions';
const Actions = exports.Actions = /*#__PURE__*/_react2.default.memo(ActionsComponent);