"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCountField = exports.fieldHasCellActions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// All cell actions are disabled for these fields in Security
const FIELDS_WITHOUT_CELL_ACTIONS = ['signal.rule.risk_score', 'kibana.alert.risk_score', 'signal.reason', 'kibana.alert.reason'];
const fieldHasCellActions = field => {
  return !!field && !FIELDS_WITHOUT_CELL_ACTIONS.includes(field);
};
exports.fieldHasCellActions = fieldHasCellActions;
const isCountField = (fieldType, sourceParamType) => {
  return fieldType === 'number' && sourceParamType === 'value_count';
};
exports.isCountField = isCountField;