"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreeWayMergeOutcome = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The type of result of an automatic three-way merge of three values:
 *   - current version
 *   - target version
 *   - merged version
 */
let ThreeWayMergeOutcome = exports.ThreeWayMergeOutcome = /*#__PURE__*/function (ThreeWayMergeOutcome) {
  ThreeWayMergeOutcome["Current"] = "CURRENT";
  ThreeWayMergeOutcome["Target"] = "TARGET";
  ThreeWayMergeOutcome["Merged"] = "MERGED";
  return ThreeWayMergeOutcome;
}({});