"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSessionExpirationToast = exports.SessionExpirationToast = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/session/session_expiration_toast.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SessionExpirationToast = ({
  sessionState$
}) => {
  const state = (0, _useObservable.default)(sessionState$);
  if (!state || !state.expiresInMs) {
    return null;
  }
  const timeoutSeconds = Math.max(state.expiresInMs - _constants.SESSION_GRACE_PERIOD_MS, 0) / 1000;
  const expirationWarning = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.sessionExpirationToast.body",
    defaultMessage: "You will be logged out {timeout}. Please save your work and log in again.",
    values: {
      timeout: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, {
        value: timeoutSeconds,
        updateIntervalInSeconds: 1,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 18
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
  return expirationWarning;
};
exports.SessionExpirationToast = SessionExpirationToast;
const createSessionExpirationToast = (services, sessionState$, onClose) => {
  return {
    color: 'warning',
    iconType: 'clock',
    title: _i18n.i18n.translate('xpack.security.sessionExpirationToast.title', {
      defaultMessage: 'Session timeout'
    }),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(SessionExpirationToast, {
      sessionState$: sessionState$,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 24
      }
    }), services),
    onClose,
    toastLifeTimeMs: 0x7fffffff // Toast is hidden based on observable so using maximum possible timeout
  };
};
exports.createSessionExpirationToast = createSessionExpirationToast;