"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserForm = exports.THROTTLE_USERS_WAIT = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _model = require("../../../../common/model");
var _use_form = require("../../../components/use_form");
var _role_combo_box = require("../../role_combo_box");
var _roles = require("../../roles");
var _user_api_client = require("../user_api_client");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/users/edit_user/user_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const THROTTLE_USERS_WAIT = exports.THROTTLE_USERS_WAIT = 10000;
const defaultDefaultValues = {
  username: '',
  password: '',
  confirm_password: '',
  full_name: '',
  email: '',
  roles: []
};
const UserForm = ({
  isNewUser = false,
  isReservedUser = false,
  defaultValues = defaultDefaultValues,
  onSuccess,
  onCancel,
  disabled = false
}) => {
  var _rolesState$value, _form$values$roles;
  const {
    services
  } = (0, _public.useKibana)();
  const [rolesState, getRoles] = (0, _useAsyncFn.default)(() => new _roles.RolesAPIClient(services.http).getRoles(), [services.http]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const getUsersThrottled = (0, _react.useCallback)((0, _lodash.throttle)(() => new _user_api_client.UserAPIClient(services.http).getUsers(), THROTTLE_USERS_WAIT), [services.http]);
  const [form, eventHandlers] = (0, _use_form.useForm)({
    onSubmit: async values => {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      const {
        password,
        confirm_password,
        ...rest
      } = values;
      const user = isNewUser ? {
        password,
        ...rest
      } : rest;
      try {
        await new _user_api_client.UserAPIClient(services.http).saveUser(user);
        services.notifications.toasts.addSuccess(isNewUser ? _i18n.i18n.translate('xpack.security.management.users.userForm.createSuccessMessage', {
          defaultMessage: "Created user ''{username}''",
          values: {
            username: user.username
          }
        }) : _i18n.i18n.translate('xpack.security.management.users.userForm.updateSuccessMessage', {
          defaultMessage: "Updated user ''{username}''",
          values: {
            username: user.username
          }
        }));
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      } catch (error) {
        var _body;
        services.notifications.toasts.addDanger({
          title: isNewUser ? _i18n.i18n.translate('xpack.security.management.users.userForm.createErrorMessage', {
            defaultMessage: "Could not create user ''{username}''",
            values: {
              username: user.username
            }
          }) : _i18n.i18n.translate('xpack.security.management.users.userForm.updateErrorMessage', {
            defaultMessage: "Could not update user ''{username}''",
            values: {
              username: user.username
            }
          }),
          text: ((_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || error.message
        });
        throw error;
      }
    },
    validate: async values => {
      const errors = {};
      if (isNewUser) {
        if (!values.username) {
          errors.username = _i18n.i18n.translate('xpack.security.management.users.userForm.usernameRequiredError', {
            defaultMessage: 'Enter a username.'
          });
        } else if (values.username.length > _constants.MAX_NAME_LENGTH) {
          errors.username = _i18n.i18n.translate('xpack.security.management.users.userForm.usernameMaxLengthError', {
            defaultMessage: 'Username must not exceed {maxLength} characters.',
            values: {
              maxLength: _constants.MAX_NAME_LENGTH
            }
          });
        } else if (values.username.trim() !== values.username) {
          errors.username = _i18n.i18n.translate('xpack.security.management.users.userForm.usernameWhitespaceError', {
            defaultMessage: `Username must not contain leading or trailing spaces.`
          });
        } else if (!values.username.match(_constants.NAME_REGEX)) {
          errors.username = _i18n.i18n.translate('xpack.security.management.users.userForm.usernameInvalidError', {
            defaultMessage: 'Username must contain only letters, numbers, spaces, punctuation, and symbols.'
          });
        } else {
          try {
            const users = await getUsersThrottled();
            if (users !== null && users !== void 0 && users.some(user => user.username === values.username)) {
              errors.username = _i18n.i18n.translate('xpack.security.management.users.userForm.usernameTakenError', {
                defaultMessage: "User ''{username}'' already exists.",
                values: {
                  username: values.username
                }
              });
            }
          } catch (error) {} // eslint-disable-line no-empty
        }
        if (!values.password) {
          errors.password = _i18n.i18n.translate('xpack.security.management.users.userForm.passwordRequiredError', {
            defaultMessage: 'Enter a password.'
          });
        } else if (values.password.length < 6) {
          errors.password = _i18n.i18n.translate('xpack.security.management.users.userForm.passwordInvalidError', {
            defaultMessage: 'Password must be at least 6 characters.'
          });
        } else if (!values.confirm_password) {
          errors.confirm_password = _i18n.i18n.translate('xpack.security.management.users.userForm.confirmPasswordRequiredError', {
            defaultMessage: 'Passwords do not match.'
          });
        } else if (values.password !== values.confirm_password) {
          errors.confirm_password = _i18n.i18n.translate('xpack.security.management.users.userForm.confirmPasswordInvalidError', {
            defaultMessage: 'Passwords do not match.'
          });
        }
      }
      return errors;
    },
    defaultValues
  });
  (0, _react.useEffect)(() => {
    form.reset(defaultValues);
  }, [defaultValues]); // eslint-disable-line react-hooks/exhaustive-deps

  (0, _react.useEffect)(() => {
    getRoles();
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  const availableRoles = (_rolesState$value = rolesState.value) !== null && _rolesState$value !== void 0 ? _rolesState$value : [];
  const selectedRoleNames = (_form$values$roles = form.values.roles) !== null && _form$values$roles !== void 0 ? _form$values$roles : [];
  const deprecatedRoles = selectedRoleNames.reduce((roles, name) => {
    const role = availableRoles.find(r => r.name === name);
    if (role && (0, _model.isRoleDeprecated)(role)) {
      roles.push(role);
    }
    return roles;
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    error: Object.values(form.errors),
    isInvalid: form.isInvalid,
    invalidCallout: form.isSubmitted ? 'above' : 'none',
    onSubmit: eventHandlers.onSubmit,
    noValidate: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.userForm.profileTitle",
      defaultMessage: "Profile",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 13
      }
    })),
    description: _i18n.i18n.translate('xpack.security.management.users.userForm.profileDescription', {
      defaultMessage: 'Provide personal details.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.userForm.usernameLabel', {
      defaultMessage: 'Username'
    }),
    helpText: !isNewUser && !isReservedUser ? _i18n.i18n.translate('xpack.security.management.users.userForm.changingUserNameAfterCreationDescription', {
      defaultMessage: 'User name cannot be changed after account creation.'
    }) : undefined,
    error: form.errors.username,
    isInvalid: form.touched.username && !!form.errors.username,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "username",
    "data-test-subj": 'userFormUserNameInput',
    icon: "user",
    value: form.values.username,
    isLoading: form.isValidating,
    isInvalid: form.touched.username && !!form.errors.username,
    disabled: disabled || !isNewUser,
    onChange: disabled || !isNewUser ? undefined : eventHandlers.onChange,
    onBlur: eventHandlers.onBlur,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 11
    }
  })), !isReservedUser ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.userForm.fullNameLabel', {
      defaultMessage: 'Full name'
    }),
    error: form.errors.full_name,
    isInvalid: form.touched.full_name && !!form.errors.full_name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "full_name",
    "data-test-subj": 'userFormFullNameInput',
    value: form.values.full_name,
    isInvalid: form.touched.full_name && !!form.errors.full_name,
    onChange: eventHandlers.onChange,
    onBlur: eventHandlers.onBlur,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.userForm.emailLabel', {
      defaultMessage: 'Email address'
    }),
    error: form.errors.email,
    isInvalid: form.touched.email && !!form.errors.email,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "email",
    "data-test-subj": 'userFormEmailInput',
    value: form.values.email,
    isInvalid: form.touched.email && !!form.errors.email,
    onChange: eventHandlers.onChange,
    onBlur: eventHandlers.onBlur,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  }))) : undefined), isNewUser ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.userForm.passwordTitle",
      defaultMessage: "Password",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 323,
        columnNumber: 15
      }
    })),
    description: _i18n.i18n.translate('xpack.security.management.users.userForm.passwordDescription', {
      defaultMessage: 'Protect your data with a strong password.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.userForm.passwordLabel', {
      defaultMessage: 'Password'
    }),
    helpText: _i18n.i18n.translate('xpack.security.management.users.userForm.passwordHelpText', {
      defaultMessage: 'Password must be at least 6 characters.'
    }),
    error: form.errors.password,
    isInvalid: form.touched.password && !!form.errors.password,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    name: "password",
    "data-test-subj": 'passwordInput',
    type: "dual",
    value: form.values.password,
    isInvalid: form.touched.password && !!form.errors.password,
    autoComplete: "new-password",
    onChange: eventHandlers.onChange,
    onBlur: eventHandlers.onBlur,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.userForm.confirmPasswordLabel', {
      defaultMessage: 'Confirm password'
    }),
    error: form.errors.confirm_password,
    isInvalid: form.touched.confirm_password && !!form.errors.confirm_password,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    name: "confirm_password",
    "data-test-subj": 'passwordConfirmationInput',
    type: "dual",
    value: form.values.confirm_password,
    isInvalid: form.touched.confirm_password && !!form.errors.confirm_password,
    autoComplete: "new-password",
    onChange: eventHandlers.onChange,
    onBlur: eventHandlers.onBlur,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 13
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 381,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.userForm.privilegesTitle",
      defaultMessage: "Privileges",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 13
      }
    })),
    description: _i18n.i18n.translate('xpack.security.management.users.userForm.privilegesDescription', {
      defaultMessage: 'Assign roles to manage access and permissions.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.userForm.rolesLabel', {
      defaultMessage: 'Roles'
    }),
    helpText: !isReservedUser && deprecatedRoles.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 15
      }
    }, deprecatedRoles.map(role => {
      var _role$metadata, _role$metadata$_depre;
      return /*#__PURE__*/_react.default.createElement("p", {
        key: role.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 403,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.users.userForm.deprecatedRolesAssignedWarning",
        defaultMessage: "Role ''{name}'' is deprecated. {reason}.",
        values: {
          name: role.name,
          reason: (_role$metadata = role.metadata) === null || _role$metadata === void 0 ? void 0 : (_role$metadata$_depre = _role$metadata._deprecated_reason) === null || _role$metadata$_depre === void 0 ? void 0 : _role$metadata$_depre.replace(/\[(.+)\]/, "'$1'")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 404,
          columnNumber: 21
        }
      }));
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: services.docLinks.links.security.roles,
      target: "_blank",
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.users.userForm.rolesHelpText",
      defaultMessage: "Learn what privileges individual roles grant.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 417,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_role_combo_box.RoleComboBox, {
    availableRoles: availableRoles,
    selectedRoleNames: selectedRoleNames,
    onChange: value => form.setValue('roles', value),
    isLoading: rolesState.loading,
    isDisabled: disabled || isReservedUser,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 9
    }
  }), disabled || isReservedUser ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "editUserFormSubmitButton",
    type: "submit",
    isLoading: form.isSubmitting,
    isDisabled: defaultValues === form.values || form.isSubmitted && form.isInvalid,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 15
    }
  }, isNewUser ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.userForm.createUserButton",
    defaultMessage: "{isSubmitting, select, true{Creating user\u2026} other{Create user}}",
    values: {
      isSubmitting: form.isSubmitting
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.userForm.updateUserButton",
    defaultMessage: "{isSubmitting, select, true{Updating user\u2026} other{Update user}}",
    values: {
      isSubmitting: form.isSubmitting
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 19
    }
  }))), isNewUser ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    isDisabled: form.isSubmitting,
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.userForm.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 463,
      columnNumber: 19
    }
  }))) : undefined)));
};
exports.UserForm = UserForm;