"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualRuleEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _field_rule_editor = require("./field_rule_editor");
var _rule_group_editor = require("./rule_group_editor");
var _model = require("../../model");
var _is_rule_group = require("../services/is_rule_group");
var _role_mapping_constants = require("../services/role_mapping_constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/rule_editor_panel/visual_rule_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class VisualRuleEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "canUseVisualEditor", () => this.props.maxDepth < _role_mapping_constants.VISUAL_MAX_RULE_DEPTH);
    (0, _defineProperty2.default)(this, "getRuleDepthWarning", () => {
      if (this.canUseVisualEditor()) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "warning",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.visualRuleEditor.switchToJSONEditorTitle",
          defaultMessage: "Switch to JSON editor",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 13
          }
        }),
        "data-test-subj": "roleMappingsRulesTooComplex",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualRuleEditor.switchToJSONEditorMessage",
        defaultMessage: "Role mapping rules are too complex for the visual editor. Switch to the JSON editor to continue editing this rule.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.props.onSwitchEditorMode,
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualRuleEditor.switchToJSONEditorButton",
        defaultMessage: "Use JSON editor",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "onRuleChange", updatedRule => {
      this.props.onChange(updatedRule);
    });
    (0, _defineProperty2.default)(this, "onRuleDelete", () => {
      this.props.onChange(null);
    });
    (0, _defineProperty2.default)(this, "renderRule", (rule, onChange) => {
      return this.getEditorForRuleType(rule, onChange);
    });
  }
  render() {
    if (this.props.rules) {
      const rules = this.renderRule(this.props.rules, this.onRuleChange);
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 9
        }
      }, this.getRuleDepthWarning(), rules);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualRuleEditor.noRulesDefinedTitle",
        defaultMessage: "No rules defined",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 13
        }
      })),
      titleSize: "s",
      body: /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.visualRuleEditor.noRulesDefinedMessage",
        defaultMessage: "Rules control which users should be assigned roles.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 13
        }
      })),
      "data-test-subj": "roleMappingsNoRulesDefined",
      actions: !this.props.readOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        iconType: "plusInCircle",
        "data-test-subj": "roleMappingsAddRuleButton",
        onClick: () => {
          this.props.onChange(new _model.AllRule([new _model.FieldRule('username', '*')]));
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.addFirstRuleButton",
        defaultMessage: "Add rules",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 15
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    });
  }
  getEditorForRuleType(rule, onChange) {
    if ((0, _is_rule_group.isRuleGroup)(rule)) {
      return /*#__PURE__*/_react.default.createElement(_rule_group_editor.RuleGroupEditor, {
        rule: rule,
        ruleDepth: 0,
        allowAdd: this.canUseVisualEditor(),
        onChange: value => onChange(value),
        onDelete: this.onRuleDelete,
        readOnly: this.props.readOnly,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_field_rule_editor.FieldRuleEditor, {
      rule: rule,
      onChange: value => onChange(value),
      onDelete: this.onRuleDelete,
      readOnly: this.props.readOnly,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 7
      }
    });
  }
}
exports.VisualRuleEditor = VisualRuleEditor;
(0, _defineProperty2.default)(VisualRuleEditor, "defaultProps", {
  readOnly: false
});