"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UseRunQueryRuleset = void 0;
var _react = _interopRequireWildcard(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _tryInConsole = require("@kbn/try-in-console");
var _use_fetch_query_ruleset = require("./use_fetch_query_ruleset");
var _use_kibana = require("./use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/hooks/use_run_query_ruleset.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UseRunQueryRuleset = ({
  rulesetId,
  type = 'emptyButton',
  content,
  color,
  onClick,
  disabled = false
}) => {
  const {
    application,
    share,
    console: consolePlugin
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: queryRulesetData
  } = (0, _use_fetch_query_ruleset.useFetchQueryRuleset)(rulesetId, !disabled);

  // Loop through all actions children to gather unique _index values
  const {
    indices,
    matchCriteria
  } = (0, _react.useMemo)(() => {
    const indicesSet = new Set();
    const criteriaData = [];
    for (const rule of (_queryRulesetData$rul = queryRulesetData === null || queryRulesetData === void 0 ? void 0 : queryRulesetData.rules) !== null && _queryRulesetData$rul !== void 0 ? _queryRulesetData$rul : []) {
      var _queryRulesetData$rul, _rule$actions, _rule$actions$docs;
      // Collect indices
      (_rule$actions = rule.actions) === null || _rule$actions === void 0 ? void 0 : (_rule$actions$docs = _rule$actions.docs) === null || _rule$actions$docs === void 0 ? void 0 : _rule$actions$docs.forEach(doc => {
        if (doc._index) indicesSet.add(doc._index);
      });

      // Collect criteria
      const criteriaArray = Array.isArray(rule.criteria) ? rule.criteria : rule.criteria ? [rule.criteria] : [];
      for (const criterion of criteriaArray) {
        if (criterion.values && typeof criterion.values === 'object' && !Array.isArray(criterion.values)) {
          Object.entries(criterion.values).forEach(([key, value]) => {
            criteriaData.push({
              metadata: key,
              values: value
            });
          });
        } else {
          criteriaData.push({
            metadata: criterion.metadata || null,
            values: criterion.values || null
          });
        }
      }
    }
    const reducedCriteria = criteriaData.reduce((acc, {
      metadata,
      values
    }) => {
      if (metadata && values !== undefined) acc[metadata] = values ? values[0] : '';
      return acc;
    }, {});
    return {
      indices: indicesSet.size > 0 ? Array.from(indicesSet).join(',') : 'my_index',
      matchCriteria: Object.keys(reducedCriteria).length > 0 ? JSON.stringify(reducedCriteria, null, 2).split('\n').join('\n         ') : `{\n         "user_query": "pugs"\n    }`
    };
  }, [queryRulesetData]);
  // Example based on https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rule-query#_example_request_2
  const TEST_QUERY_RULESET_API_SNIPPET = (0, _dedent.default)`
    # Get Query Ruleset
    GET _query_rules/${rulesetId}


    # Query Rules Retriever Example
    # https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers#rule-retriever
    GET ${indices}/_search
    {
      "retriever": {
        "rule": {
          // Update your criteria to test different results
          "match_criteria": ${matchCriteria},
          "ruleset_ids": [
            "${rulesetId}" // An array of one or more unique query ruleset IDs
          ],
          "retriever": {
            "standard": {
              "query": {
                "match_all": {} // replace with your query
              }
            }
          }
        }
      }
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    disabled: disabled,
    application: application,
    sharePlugin: share !== null && share !== void 0 ? share : undefined,
    consolePlugin: consolePlugin !== null && consolePlugin !== void 0 ? consolePlugin : undefined,
    request: TEST_QUERY_RULESET_API_SNIPPET,
    type: type,
    content: content,
    color: color,
    showIcon: true,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  });
};
exports.UseRunQueryRuleset = UseRunQueryRuleset;