"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCitations = getCitations;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getCitations(answer, citationStyle, docs) {
  const gatheredCitations = answer.match(/\[\d+\]/g);
  if (!gatheredCitations) return [];
  return docs.filter((doc, i) => {
    return gatheredCitations.some(citation => {
      return i + 1 === parseInt(citation.slice(1, -1), 10);
    });
  });
}