"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavePlaygroundModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _errors = require("../../../common/errors");
var _saved_playgrounds = require("../../utils/saved_playgrounds");
var _use_save_playground = require("../../hooks/use_save_playground");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/save_playground_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function makePlaygroundName(name) {
  return name ? _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.nameCopy', {
    defaultMessage: '{name} (Copy)',
    values: {
      name
    }
  }) : _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.defaultName', {
    defaultMessage: 'New Playground'
  });
}
const SavePlaygroundModal = ({
  onNavigateToNewPlayground,
  playgroundName,
  saveAs,
  onClose
}) => {
  const {
    getValues,
    reset
  } = (0, _reactHookForm.useFormContext)();
  const {
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const [name, setName] = (0, _react.useState)(makePlaygroundName(playgroundName));
  const [nameError, setNameError] = (0, _react.useState)((0, _saved_playgrounds.validatePlaygroundName)(makePlaygroundName(playgroundName)));
  const {
    savePlayground,
    isLoading
  } = (0, _use_save_playground.useSavePlayground)();
  const modalFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'savePlaygroundForm'
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onNameChange = (0, _react.useCallback)(e => {
    setName(e.target.value);
    setNameError((0, _saved_playgrounds.validatePlaygroundName)(e.target.value));
  }, []);
  const onSave = (0, _react.useCallback)(e => {
    e.preventDefault();
    const formData = getValues();
    const newPlayground = {
      ...formData,
      name
    };
    savePlayground((0, _saved_playgrounds.buildSavedPlaygroundFromForm)(newPlayground), {
      onSuccess: data => {
        onClose();
        reset(newPlayground);
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.saveSuccess.title', {
            defaultMessage: 'playground saved'
          }),
          text: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.saveSuccess.text', {
            defaultMessage: '{name} was saved.',
            values: {
              name: newPlayground.name
            }
          })
        });
        onNavigateToNewPlayground(data._meta.id);
      },
      onError: error => {
        const errorMessage = (0, _errors.getErrorMessage)(error);
        notifications.toasts.addError(error instanceof Error ? error : new Error(errorMessage), {
          title: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.saveError.title', {
            defaultMessage: 'Error saving playground'
          }),
          toastMessage: errorMessage
        });
        onClose();
      }
    });
  }, [onNavigateToNewPlayground, onClose, name, getValues, reset, notifications.toasts, savePlayground]);
  const isInvalid = nameError !== null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    initialFocus: "[name=playgroundName]",
    "aria-labelledby": modalTitleId,
    onClose: onClose,
    "data-test-subj": "save-playground-modal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, saveAs ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.savePlaygroundModal.title",
    defaultMessage: "Save playground as",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.savePlaygroundModal.title",
    defaultMessage: "Save playground",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: modalFormId,
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.savePlaygroundModal.name.label', {
      defaultMessage: 'Name'
    }),
    isInvalid: isInvalid,
    error: nameError ? [nameError] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "searchPlaygroundSavePlaygroundModalFieldText",
    name: "playgroundName",
    value: name,
    onChange: onNameChange,
    isInvalid: isInvalid,
    required: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchPlaygroundSavePlaygroundModalCancelButton",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.savePlaygroundModal.cancel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchPlaygroundSavePlaygroundModalSaveButton",
    type: "submit",
    iconType: "save",
    form: modalFormId,
    disabled: isInvalid,
    onClick: onSave,
    isLoading: isLoading,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, saveAs ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.savePlaygroundModal.saveAs",
    defaultMessage: "Save as",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.savePlaygroundModal.save",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }))));
};
exports.SavePlaygroundModal = SavePlaygroundModal;