"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticLLMCostTour = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../common/doc_links");
var _use_show_managed_llm_cost_tour = require("../hooks/use_show_managed_llm_cost_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/elastic_llm_cost_tour.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ElasticLLMCostTour = ({
  anchorPosition = 'downCenter',
  connectorName,
  children
}) => {
  const {
    isTourVisible,
    onSkipTour
  } = (0, _use_show_managed_llm_cost_tour.useShowManagedLLMCostTour)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.elasticLLM.costsTour.title",
      defaultMessage: "{connectorName} connector",
      values: {
        connectorName
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.elasticLLM.costsTour.subTitle",
      defaultMessage: "New AI feature!",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }),
    maxWidth: "500px",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.elasticLLM.costsTour.description",
      defaultMessage: "{connectorName} is our new default, pre-configured LLM connector. It will incur {additionalCostsLink} You can continue to use other LLM connectors as normal. {learnMoreLink}",
      values: {
        connectorName,
        additionalCostsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "elasticLLMAdditionalCostsLink",
          target: "_blank",
          href: _doc_links.docLinks.elasticLLMCosts,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 54,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.elasticLLM.costsTour.additionalCostsLink",
          defaultMessage: "additional costs.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 59,
            columnNumber: 21
          }
        })),
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "elasticLLMLearnMoreLink",
          target: "_blank",
          href: _doc_links.docLinks.elasticLLM,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.elasticLLM.costsTour.learnModeLink",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 71,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }))),
    isStepOpen: isTourVisible,
    anchorPosition: anchorPosition,
    step: 1,
    stepsTotal: 1,
    onFinish: onSkipTour,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "elasticLLMCostsTourCloseBtn",
      onClick: onSkipTour,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.elasticLLM.costsTour.closeButton",
      defaultMessage: "Ok",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, children);
};
exports.ElasticLLMCostTour = ElasticLLMCostTour;