"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditContextPanel = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_source_indices_field = require("../../hooks/use_source_indices_field");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _constants = require("../../analytics/constants");
var _context_fields_select = require("./context_fields_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/edit_context/edit_context_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditContextPanel = () => {
  const idPrefix = 'playground_context_doc_number';
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    fields
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const {
    field: {
      onChange: onChangeSize,
      value: docSize
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.docSize
  });
  const {
    field: {
      onChange: onChangeSourceFields,
      value: sourceFields
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.sourceFields
  });
  const updateSourceField = (0, _react.useCallback)((index, contextFields) => {
    onChangeSourceFields({
      ...sourceFields,
      [index]: contextFields
    });
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextFieldToggled);
  }, [onChangeSourceFields, sourceFields, usageTracker]);
  const handleDocSizeButtonGroupChange = value => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextDocSizeChanged);
    onChangeSize(value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "editContextPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.documentsSize.table.title",
    defaultMessage: "Documents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.docsRetrievedCount",
    defaultMessage: "Number of documents sent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": "documentSizeButtonGroup",
    legend: "Number of documents sent",
    isFullWidth: true,
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}-1`,
      label: '1',
      value: 1,
      'data-test-subj': `${idPrefix}-1`
    }, {
      id: `${idPrefix}-3`,
      label: '3',
      value: 3,
      'data-test-subj': `${idPrefix}-3`
    }, {
      id: `${idPrefix}-5`,
      label: '5',
      value: 5,
      'data-test-subj': `${idPrefix}-5`
    }, {
      id: `${idPrefix}-10`,
      label: '10',
      value: 10,
      'data-test-subj': `${idPrefix}-10`
    }],
    idSelected: `${idPrefix}-${docSize}`,
    onChange: (_, value) => handleDocSizeButtonGroupChange(value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.table.title",
    defaultMessage: "Context fields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 19
    }
  })))), Object.entries(fields).map(([index, group]) => {
    var _sourceFields$index;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: index,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_context_fields_select.ContextFieldsSelect, {
      indexName: index,
      indexFields: group,
      selectedContextFields: (_sourceFields$index = sourceFields[index]) !== null && _sourceFields$index !== void 0 ? _sourceFields$index : [],
      updateSelectedContextFields: updateSourceField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 19
      }
    })));
  })))));
};
exports.EditContextPanel = EditContextPanel;