"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchWithPagination = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultResult = data => ({
  _meta: {
    page: {
      from: 0,
      has_more_hits_than_total: false,
      size: 10,
      total: 0
    }
  },
  data
});
const fetchWithPagination = async (fetchFunction, from, size) => {
  if (size === 0) {
    return defaultResult([]);
  }
  const result = await fetchFunction();
  const total = totalToPaginateTotal(result.hits.total);
  return {
    _meta: {
      page: {
        from,
        size,
        ...total
      }
    },
    data: result.hits.hits
  };
};
exports.fetchWithPagination = fetchWithPagination;
function totalToPaginateTotal(input) {
  if (typeof input === 'number') {
    return {
      has_more_hits_than_total: false,
      total: input
    };
  }
  return input ? {
    has_more_hits_than_total: input.relation === 'gte' ? true : false,
    total: input.value
  } : {
    has_more_hits_than_total: false,
    total: 0
  };
}