"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleDataActionButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_ingest_data = require("../hooks/use_ingest_data");
var _use_sample_data_status = require("../hooks/use_sample_data_status");
var _use_kibana = require("../hooks/use_kibana");
var _use_navigate_to_discover = require("../hooks/use_navigate_to_discover");
var _use_navigate_to_dashboard = require("../hooks/use_navigate_to_dashboard");
var _constants = require("../analytics/constants");
var _use_usage_tracker = require("../hooks/use_usage_tracker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/sample_data_action_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SampleDataActionButton = ({
  clickEvent = _constants.AnalyticsEvents.installSampleDataClick,
  hasRequiredLicense = false
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    ingestSampleData,
    isLoading
  } = (0, _use_ingest_data.useIngestSampleData)();
  const {
    share,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const {
    isInstalled,
    indexName,
    dashboardId,
    isLoading: isStatusLoading
  } = (0, _use_sample_data_status.useSampleDataStatus)();
  const [isShowViewDataOptions, setShowViewDataOptions] = (0, _react.useState)(false);
  const isAgentBuilderAvailable = uiSettings.get(_managementSettingsIds.AGENT_BUILDER_ENABLED_SETTING_ID, false);
  const onInstallButtonClick = (0, _react.useCallback)(() => {
    usageTracker.click(clickEvent);
    ingestSampleData();
  }, [ingestSampleData, usageTracker, clickEvent]);
  const onViewButtonClick = (0, _react.useCallback)(() => {
    setShowViewDataOptions(true);
  }, []);
  const onClosePopover = (0, _react.useCallback)(() => {
    setShowViewDataOptions(false);
  }, []);
  const navigateToPlayground = (0, _react.useCallback)(async () => {
    const playgroundLocator = share.url.locators.get('PLAYGROUND_LOCATOR_ID');
    const isSearchAvailable = uiSettings.get('searchPlayground:searchModeEnabled', false);
    if (playgroundLocator && indexName) {
      await playgroundLocator.navigate({
        'default-index': indexName,
        search: isSearchAvailable
      });
    }
  }, [share, uiSettings, indexName]);
  const navigateToDiscover = (0, _use_navigate_to_discover.useNavigateToDiscover)(indexName || '');
  const navigateToDashboard = (0, _use_navigate_to_dashboard.useNavigateToDashboard)(dashboardId);
  const navigateToIndexDetails = (0, _react.useCallback)(async () => {
    const indexDetailsLocator = share.url.locators.get('SEARCH_INDEX_DETAILS_LOCATOR_ID');
    if (indexDetailsLocator && indexName) {
      await indexDetailsLocator.navigate({
        indexName
      });
    }
  }, [share, indexName]);
  const navigateToAgentBuilder = (0, _react.useCallback)(async () => {
    if (isAgentBuilderAvailable) {
      const agentBuilderLocator = share.url.locators.get('AGENT_BUILDER_LOCATOR_ID');
      await (agentBuilderLocator === null || agentBuilderLocator === void 0 ? void 0 : agentBuilderLocator.navigate({}));
    }
  }, [share, isAgentBuilderAvailable]);
  if (isStatusLoading) {
    return null;
  }
  if (isInstalled && indexName) {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "text",
      "data-test-subj": "viewDataBtn",
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onViewButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchHomepage.sampleData.view",
      defaultMessage: "View Data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: button,
      isOpen: isShowViewDataOptions,
      closePopover: onClosePopover,
      anchorPosition: "downLeft",
      panelPaddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      css: {
        minWidth: 250
      },
      items: [...(isAgentBuilderAvailable ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "agentBuilder",
        onClick: navigateToAgentBuilder,
        icon: "comment",
        "data-test-subj": "agentBuilderMenuItem",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchHomepage.shared.createIndex.ingestSampleData.linkToAgentBuilder",
        defaultMessage: "Agents",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 23
        }
      }))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "discover",
        onClick: navigateToDiscover,
        icon: "discoverApp",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchHomepage.sampleData.linkToDiscover",
        defaultMessage: "Discover",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 17
        }
      })), ...(dashboardId ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "dashboard",
        onClick: navigateToDashboard,
        icon: "dashboardApp",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchHomepage.createIndex.ingestSampleData.linkToDashboard",
        defaultMessage: "Dashboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 23
        }
      }))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "playground",
        onClick: navigateToPlayground,
        icon: "comment",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchHomepage.sampleData.linkToPlayground",
        defaultMessage: "Playground",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "index",
        onClick: navigateToIndexDetails,
        icon: "index",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchHomepage.sampleData.linkToIndex",
        defaultMessage: "View index",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 17
        }
      }))],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    })));
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    iconSide: "left",
    iconType: "download",
    size: "s",
    "data-test-subj": "installSampleBtn",
    isLoading: isLoading,
    disabled: !hasRequiredLicense,
    onClick: onInstallButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.sampleData.btn",
    defaultMessage: "Sample knowledge base",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }));
  return hasRequiredLicense ? button : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    title: _i18n.i18n.translate('xpack.searchHomepage.sampleData.licenseTooltip.title', {
      defaultMessage: 'Enterprise'
    }),
    content: _i18n.i18n.translate('xpack.searchHomepage.sampleData.licenseTooltip.description', {
      defaultMessage: 'This dataset makes use of AI features that require an Enterprise license.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 5
    }
  }, button);
};
exports.SampleDataActionButton = SampleDataActionButton;