"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobDocumentsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _byte_size_value = require("@kbn/config-schema/src/byte_size_value");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _flyout_panel = require("./flyout_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/sync_jobs/documents_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// importing from file to avoid leaking `joi` to the browser
const SyncJobDocumentsPanel = syncJobDocuments => {
  const columns = [{
    field: 'added',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "searchConnectors.index.syncJobs.documents.upserted.tooltip",
        defaultMessage: "Number of {index} operations the connector sent to the Elasticsearch _bulk API, including updates to existing documents. Note that the number of documents upserted and the number of documents in the index may differ.",
        values: {
          index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 36,
              columnNumber: 32
            }
          }, "index")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('searchConnectors.index.syncJobs.documents.added', {
      defaultMessage: 'Upserted'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "question",
      color: "subdued",
      className: "eui-alignTop",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    })))
  }, {
    field: 'removed',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "searchConnectors.index.syncJobs.documents.deleted.tooltip",
        defaultMessage: "Number of {delete} operations the connector sent to the Elasticsearch _bulk API. May include documents dropped by Sync Rules. Does not include documents dropped by ingest processors. Documents are deleted when the connector determines they are no longer present in the third-party source.",
        values: {
          delete: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 57,
              columnNumber: 33
            }
          }, "delete")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('searchConnectors.index.syncJobs.documents.removed', {
      defaultMessage: 'Deleted'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "question",
      color: "subdued",
      className: "eui-alignTop",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    })))
  }, {
    field: 'volume',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "searchConnectors.index.syncJobs.documents.volume.tooltip",
        defaultMessage: "Volume (in MB) of JSON data sent with {index} operations to the Elasticsearch _bulk API. The Elasticsearch index may be larger, depending on index mappings and settings, or smaller, if data is trimmed by ingest processors.",
        values: {
          index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 78,
              columnNumber: 32
            }
          }, "index")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('searchConnectors.index.syncJobs.documents.volume', {
      defaultMessage: 'Volume'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "question",
      color: "subdued",
      className: "eui-alignTop",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    }))),
    render: volume => volume < 1 ? _i18n.i18n.translate('searchConnectors.index.syncJobs.documents.volume.lessThanOneMBLabel', {
      defaultMessage: 'Less than 1mb'
    }) : _i18n.i18n.translate('searchConnectors.index.syncJobs.documents.volume.aboutLabel', {
      defaultMessage: 'About {volume}',
      values: {
        volume: new _byte_size_value.ByteSizeValue(volume * 1024 * 1024).toString()
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_flyout_panel.FlyoutPanel, {
    title: _i18n.i18n.translate('searchConnectors.index.syncJobs.documents.title', {
      defaultMessage: 'Documents'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: [syncJobDocuments],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }));
};
exports.SyncJobDocumentsPanel = SyncJobDocumentsPanel;