"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelationshipsClass = exports.Relationships = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _lib = require("../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/components/relationships.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const relationshipColumn = {
  field: 'relationship',
  name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnRelationshipName', {
    defaultMessage: 'Direct relationship'
  }),
  dataType: 'string',
  sortable: false,
  width: '125px',
  'data-test-subj': 'directRelationship',
  render: relationship => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, relationship === 'parent' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.relationships.columnRelationship.parentAsValue",
      defaultMessage: "Parent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.relationships.columnRelationship.childAsValue",
      defaultMessage: "Child",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }));
  }
};
class RelationshipsClass extends _react.Component {
  render() {
    const modalTitleId = (0, _eui.htmlIdGenerator)()('relationshipsFlyoutTitle');
    const {
      close,
      savedObject,
      allowedTypes
    } = this.props;
    const typeLabel = (0, _lib.getSavedObjectLabel)(savedObject.type, allowedTypes);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: close,
      "aria-labelledby": modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "top",
      content: typeLabel,
      type: savedObject.meta.icon || 'apps',
      size: "m",
      "aria-label": typeLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 15
      }
    }), "\xA0\xA0", savedObject.meta.title || (0, _lib.getDefaultTitle)(savedObject)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }, this.renderInvalidRelationship(), this.renderRelationshipsTable()));
  }
  constructor(props) {
    super(props);
    this.state = {
      relations: [],
      invalidRelations: [],
      isLoading: false,
      error: undefined
    };
  }
  UNSAFE_componentWillMount() {
    this.getRelationshipData();
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    if (nextProps.savedObject.id !== this.props.savedObject.id) {
      this.getRelationshipData();
    }
  }
  async getRelationshipData() {
    const {
      savedObject,
      getRelationships
    } = this.props;
    this.setState({
      isLoading: true
    });
    try {
      const {
        relations,
        invalidRelations
      } = await getRelationships(savedObject.type, savedObject.id);
      this.setState({
        relations,
        invalidRelations,
        isLoading: false,
        error: undefined
      });
    } catch (err) {
      this.setState({
        error: err.message,
        isLoading: false
      });
    }
  }
  renderError() {
    const {
      error
    } = this.state;
    if (!error) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.relationships.renderErrorMessage",
        defaultMessage: "Error",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 11
        }
      }),
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 7
      }
    }, error);
  }
  renderInvalidRelationship() {
    const {
      invalidRelations
    } = this.state;
    if (!invalidRelations.length) {
      return null;
    }
    const columns = [{
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTypeName', {
        defaultMessage: 'Type'
      }),
      width: '150px',
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTypeDescription', {
        defaultMessage: 'Type of the saved object'
      }),
      sortable: false,
      'data-test-subj': 'relationshipsObjectType'
    }, {
      field: 'id',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnIdName', {
        defaultMessage: 'Id'
      }),
      width: '150px',
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnIdDescription', {
        defaultMessage: 'Id of the saved object'
      }),
      sortable: false,
      'data-test-subj': 'relationshipsObjectId'
    }, relationshipColumn, {
      field: 'error',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnErrorName', {
        defaultMessage: 'Error'
      }),
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnErrorDescription', {
        defaultMessage: 'Error encountered with the relation'
      }),
      sortable: false,
      'data-test-subj': 'relationshipsError'
    }];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "warning",
      title: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.invalidRelationShip', {
        defaultMessage: 'This saved object has some invalid relations.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: invalidRelations,
      columns: columns,
      pagination: true,
      rowProps: () => ({
        'data-test-subj': `invalidRelationshipsTableRow`
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 9
      }
    }));
  }
  renderRelationshipsTable() {
    const {
      goInspectObject,
      basePath,
      savedObject,
      allowedTypes,
      showPlainSpinner,
      euiTablePersist: {
        pageSize,
        onTableChange
      }
    } = this.props;
    const {
      relations,
      isLoading,
      error
    } = this.state;
    if (error) {
      return this.renderError();
    }
    if (isLoading) {
      return showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 33
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 67
        }
      });
    }
    const columns = [{
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTypeName', {
        defaultMessage: 'Type'
      }),
      width: '50px',
      align: 'center',
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTypeDescription', {
        defaultMessage: 'Type of the saved object'
      }),
      sortable: false,
      render: (type, object) => {
        const typeLabel = (0, _lib.getSavedObjectLabel)(type, allowedTypes);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          position: "top",
          content: typeLabel,
          type: object.meta.icon || 'apps',
          size: "s",
          "aria-label": typeLabel,
          iconProps: {
            'data-test-subj': 'relationshipsObjectType'
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 292,
            columnNumber: 13
          }
        });
      }
    }, relationshipColumn, {
      field: 'meta.title',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTitleName', {
        defaultMessage: 'Title'
      }),
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTitleDescription', {
        defaultMessage: 'Title of the saved object'
      }),
      dataType: 'string',
      sortable: false,
      render: (title, object) => {
        const {
          path = ''
        } = object.meta.inAppUrl || {};
        const canGoInApp = this.props.canGoInApp(object);
        if (!canGoInApp) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            "data-test-subj": "relationshipsTitle",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 322,
              columnNumber: 15
            }
          }, title || (0, _lib.getDefaultTitle)(object));
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: basePath.prepend(path),
          "data-test-subj": "relationshipsTitle",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 328,
            columnNumber: 13
          }
        }, title || (0, _lib.getDefaultTitle)(object));
      }
    }, {
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnActionsName', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnActions.inspectActionName', {
          defaultMessage: 'Inspect'
        }),
        description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.columnActions.inspectActionDescription', {
          defaultMessage: 'Inspect this saved object'
        }),
        type: 'icon',
        icon: 'inspect',
        'data-test-subj': 'relationshipsTableAction-inspect',
        onClick: object => goInspectObject(object),
        available: object => !!(object.type && object.id)
      }]
    }];
    const filterTypesMap = new Map(relations.map(relationship => [relationship.type, {
      value: relationship.type,
      name: relationship.type,
      view: relationship.type
    }]));
    const search = {
      filters: [{
        type: 'field_value_selection',
        field: 'relationship',
        name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.search.filters.relationship.name', {
          defaultMessage: 'Direct relationship'
        }),
        multiSelect: 'or',
        options: [{
          value: 'parent',
          name: 'parent',
          view: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.search.filters.relationship.parentAsValue.view', {
            defaultMessage: 'Parent'
          })
        }, {
          value: 'child',
          name: 'child',
          view: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.search.filters.relationship.childAsValue.view', {
            defaultMessage: 'Child'
          })
        }]
      }, {
        type: 'field_value_selection',
        field: 'type',
        name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.search.filters.type.name', {
          defaultMessage: 'Type'
        }),
        multiSelect: 'or',
        options: [...filterTypesMap.values()]
      }]
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 414,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 415,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('savedObjectsManagement.objectsTable.relationships.relationshipsTitle', {
      defaultMessage: 'Here are the saved objects related to {title}. ' + 'Deleting this {type} affects its parent objects, but not its children.',
      values: {
        type: savedObject.type,
        title: savedObject.meta.title || (0, _lib.getDefaultTitle)(savedObject)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: relations,
      columns: columns,
      pagination: {
        pageSize
      },
      onTableChange: onTableChange,
      search: search,
      rowProps: () => ({
        'data-test-subj': `relationshipsTableRow`
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 431,
        columnNumber: 9
      }
    }));
  }
}
exports.RelationshipsClass = RelationshipsClass;
const Relationships = exports.Relationships = (0, _sharedUxTablePersist.withEuiTablePersist)(RelationshipsClass, {
  tableId: 'savedObjectsMgmtRelationships',
  initialPageSize: 10
});