"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("../../common");
var _services = require("./services");
var _kibana_services = require("../kibana_services");
var _sections = require("./sections");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/app.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ShareRouterComponent extends _react.Component {
  constructor(...args) {
    super(...args);
    this.registerRouter();
  }
  registerRouter() {
    // Share the router with the app without requiring React or context.
    const {
      history
    } = this.props;
    (0, _services.registerRouter)({
      history
    });
  }
  render() {
    return this.props.children;
  }
}
(0, _defineProperty2.default)(ShareRouterComponent, "propTypes", {
  history: _propTypes.default.shape({
    push: _propTypes.default.func.isRequired,
    createHref: _propTypes.default.func.isRequired
  }).isRequired
});
const ShareRouter = (0, _reactRouterDom.withRouter)(ShareRouterComponent);

// eslint-disable-next-line react/no-multi-comp
class App extends _react.Component {
  componentDidMount() {
    (0, _kibana_services.trackUiMetric)(_services.METRIC_TYPE.LOADED, _common.UIM_APP_LOAD);
  }
  componentWillUnmount() {
    // Set internal flag so we can prevent reacting to route changes internally.
    (0, _services.setUserHasLeftApp)(true);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: this.props.history,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(ShareRouter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      exact: true,
      from: "/",
      to: "/job_list",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: "/job_list",
      component: _sections.JobList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: "/create",
      component: _sections.JobCreate,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }))));
  }
}
exports.App = App;