"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IlmPolicyWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reportingPublic = require("@kbn/reporting-public");
var _ilm_policy_link = require("./ilm_policy_link");
var _report_diagnostic = require("./report_diagnostic");
var _ilm_policy_status_context = require("../../lib/ilm_policy_status_context");
var _migrate_ilm_policy_callout = require("./migrate_ilm_policy_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/ilm_policy_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IlmPolicyWrapper = props => {
  var _capabilities$managem, _capabilities$managem2;
  const {
    config,
    apiClient
  } = props;
  const {
    services: {
      application: {
        capabilities
      },
      share: {
        url: urlService
      },
      notifications
    }
  } = (0, _reportingPublic.useKibana)();
  const ilmLocator = urlService.locators.get('ILM_LOCATOR_ID');
  const ilmPolicyContextValue = (0, _ilm_policy_status_context.useIlmPolicyStatus)();
  const hasIlmPolicy = (ilmPolicyContextValue === null || ilmPolicyContextValue === void 0 ? void 0 : ilmPolicyContextValue.status) !== 'policy-not-found';
  const showIlmPolicyLink = Boolean(ilmLocator && hasIlmPolicy);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, (capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$managem = capabilities.management) === null || _capabilities$managem === void 0 ? void 0 : (_capabilities$managem2 = _capabilities$managem.data) === null || _capabilities$managem2 === void 0 ? void 0 : _capabilities$managem2.index_lifecycle_management) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, ilmPolicyContextValue !== null && ilmPolicyContextValue !== void 0 && ilmPolicyContextValue.isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 17
    }
  }) : showIlmPolicyLink && /*#__PURE__*/_react.default.createElement(_ilm_policy_link.IlmPolicyLink, {
    locator: ilmLocator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 38
    }
  }))), /*#__PURE__*/_react.default.createElement(_migrate_ilm_policy_callout.MigrateIlmPolicyCallOut, {
    toasts: notifications.toasts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_report_diagnostic.ReportDiagnostic, {
    clientConfig: config,
    apiClient: apiClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.IlmPolicyWrapper = IlmPolicyWrapper;