"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Settings = Settings;
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/observability-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _bottom_bar_actions = require("./bottom_bar_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LazyFieldRow = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/management-settings-components-field-row')))).FieldRow
}));
const FieldRow = (0, _sharedUxUtility.withSuspense)(LazyFieldRow);
const co2Settings = [_common.profilingCo2PerKWH, _common.profilingDatacenterPUE, _common.profilingPervCPUWattX86, _common.profilingPervCPUWattArm64];
const costSettings = [_common.profilingAWSCostDiscountRate, _common.profilingAzureCostDiscountRate, _common.profilingCostPervCPUPerHour];
const miscSettings = [_common.profilingShowErrorFrames];
function Settings() {
  const trackProfilingEvent = (0, _public.useUiTracker)({
    app: 'profiling'
  });
  const {
    start: {
      core: {
        docLinks,
        notifications,
        settings
      }
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const {
    fields,
    handleFieldChange,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _public.useEditableSettings)([...co2Settings, ...costSettings, ...miscSettings]);
  async function handleSave() {
    try {
      const reloadPage = Object.keys(unsavedChanges).some(key => {
        return fields[key].requiresPageReload;
      });
      await saveAll();
      trackProfilingEvent({
        metric: 'general_settings_save'
      });
      if (reloadPage) {
        window.location.reload();
      }
    } catch (e) {
      const error = e;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.profiling.settings.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: error.message
      });
    }
  }
  const hasInvalidChanges = Object.values(unsavedChanges).some(({
    isInvalid
  }) => isInvalid);
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    hideSearchBar: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.profiling.settings.title', {
    defaultMessage: 'Advanced Settings'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), [{
    label: _i18n.i18n.translate('xpack.profiling.settings.co2Section', {
      defaultMessage: 'Custom CO2 settings'
    }),
    description: {
      title: _i18n.i18n.translate('xpack.profiling.settings.co2.title', {
        defaultMessage: 'The Universal Profiling host agent can detect if your machine is running on AWS, Azure, or Google Cloud Platform.'
      }),
      subtitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.profiling.settings.co2.aws.subtitle",
        defaultMessage: "For machines running on AWS, Universal Profiling applies the appropriate {regionalCarbonIntensityLink} for your instance's AWS region and the current AWS data center {pue}.",
        values: {
          regionalCarbonIntensityLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "profilingSettingsLink",
            href: "https://ela.st/grid-datasheet",
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 120,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.profiling.settings.co2.subtitle.link', {
            defaultMessage: 'regional carbon intensity'
          })),
          pue: /*#__PURE__*/_react.default.createElement("strong", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 131,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.profiling.settings.co2.subtitle.pue', {
            defaultMessage: 'PUE'
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.profiling.settings.co2.azure.subtitle",
        defaultMessage: "For machines running on Azure, Universal Profiling applies the appropriate {regionalCarbonIntensityLink} for your instance's Azure region and the current Azure data center {pue}.",
        values: {
          regionalCarbonIntensityLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "profilingSettingsLink",
            href: "https://ela.st/grid-datasheet",
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 145,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.profiling.settings.co2.subtitle.link', {
            defaultMessage: 'regional carbon intensity'
          })),
          pue: /*#__PURE__*/_react.default.createElement("strong", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 156,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.profiling.settings.co2.subtitle.pue', {
            defaultMessage: 'PUE'
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 19
        }
      })),
      text: _i18n.i18n.translate('xpack.profiling.settings.co2.text', {
        defaultMessage: 'For all other configurations, Universal Profiling uses the following default configurations. You can update these configurations as needed.'
      })
    },
    settings: co2Settings
  }, {
    label: _i18n.i18n.translate('xpack.profiling.settings.costSection', {
      defaultMessage: 'Custom cost settings'
    }),
    description: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.profiling.settings.cost.title",
        defaultMessage: "Universal Profiling uses the cost for AWS EC2 instances and Azure VMs using the {awsPriceList} and {azurePriceList} respectively.",
        values: {
          awsPriceList: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "profilingSettingsLinkAws",
            href: "https://ela.st/aws-price-list",
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 184,
              columnNumber: 23
            }
          }, _i18n.i18n.translate('xpack.profiling.settings.cost.subtitle.link.aws', {
            defaultMessage: 'AWS price list'
          })),
          azurePriceList: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "profilingSettingsLinkAzure",
            href: "https://ela.st/azure-price-list",
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 195,
              columnNumber: 23
            }
          }, _i18n.i18n.translate('xpack.profiling.settings.cost.subtitle.link.azure', {
            defaultMessage: 'Azure price list'
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 17
        }
      })
    },
    settings: costSettings
  }, {
    label: _i18n.i18n.translate('xpack.profiling.settings.miscSection', {
      defaultMessage: 'Miscellaneous settings'
    }),
    description: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.profiling.settings.misc.title",
        defaultMessage: "Universal Profiling miscellaneous settings.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 17
        }
      })
    },
    settings: miscSettings
  }].map(item => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    key: item.label,
    grow: false,
    hasShadow: false,
    hasBorder: true,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 19
    }
  }, item.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 15
    }
  }, item.description ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 25
    }
  }, item.description.title && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 31
    }
  }, item.description.title)), item.description.subtitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 31
    }
  }, item.description.subtitle)), item.description.text && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 31
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 33
    }
  }, item.description.text)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 21
    }
  })) : null, item.settings.map(settingKey => {
    const field = fields[settingKey];
    return /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
      links: docLinks.links.management,
      showDanger: message => notifications.toasts.addDanger(message),
      validateChange: (key, value) => settings.client.validateValue(key, value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(FieldRow, {
      field: field,
      isSavingEnabled: true,
      onFieldChange: handleFieldChange,
      unsavedChange: unsavedChanges[settingKey],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 23
      }
    }));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 13
    }
  }))), !(0, _lodash.isEmpty)(unsavedChanges) && /*#__PURE__*/_react.default.createElement(_bottom_bar_actions.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    saveLabel: _i18n.i18n.translate('xpack.profiling.settings.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: Object.keys(unsavedChanges).length,
    areChangesInvalid: hasInvalidChanges,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 11
    }
  })));
}