"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFlamegraph = EmbeddableFlamegraph;
var _profilingUtils = require("@kbn/profiling-utils");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _flamegraph = require("../../components/flamegraph");
var _async_embeddable_component = require("../async_embeddable_component");
var _profiling_embeddable_provider = require("../profiling_embeddable_provider");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/embeddables/flamegraph/embeddable_flamegraph.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EmbeddableFlamegraph({
  data,
  isLoading,
  ...deps
}) {
  return /*#__PURE__*/_react.default.createElement(_profiling_embeddable_provider.ProfilingEmbeddableProvider, {
    deps: deps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Flamegraph, {
    isLoading: isLoading,
    data: data,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }));
}
function Flamegraph({
  isLoading,
  data
}) {
  const {
    core
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().start;
  const showErrorFrames = core.uiSettings.get(_common.profilingShowErrorFrames);
  const flamegraph = !isLoading && data ? (0, _profilingUtils.createFlameGraph)(data, showErrorFrames) : undefined;
  return /*#__PURE__*/_react.default.createElement(_async_embeddable_component.AsyncEmbeddableComponent, {
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, flamegraph && /*#__PURE__*/_react.default.createElement(_flamegraph.FlameGraph, {
    primaryFlamegraph: flamegraph,
    id: "embddable_profiling",
    isEmbedded: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  })));
}