"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipRow = TooltipRow;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _as_percentage = require("../../utils/formatters/as_percentage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/flamegraph/tooltip_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TooltipRow({
  value,
  label,
  comparison,
  formatDifferenceAsPercentage,
  showDifference,
  formatValue,
  prependValue = ''
}) {
  const valueLabel = `${prependValue}${formatValue ? formatValue(Math.abs(value)) : value.toString()}`;
  const comparisonLabel = formatValue && (0, _lodash.isNumber)(comparison) ? formatValue(comparison) : comparison === null || comparison === void 0 ? void 0 : comparison.toString();
  let diff;
  let diffLabel = '';
  let color = '';
  if ((0, _lodash.isNumber)(comparison)) {
    if (showDifference) {
      color = value < comparison ? 'danger' : 'success';
      if (formatDifferenceAsPercentage) {
        // CPU percent values
        diff = comparison - value;
        diffLabel = '(' + (diff > 0 ? '+' : diff < 0 ? '-' : '') + (0, _as_percentage.asPercentage)(Math.abs(diff)) + ')';
      } else {
        // Sample counts
        diff = 1 - comparison / value;
        diffLabel = '(' + (diff > 0 ? '-' : diff < 0 ? '+' : '') + (0, _as_percentage.asPercentage)(Math.abs(diff)) + ')';
      }
      if (Math.abs(diff) < 0.0001) {
        diffLabel = '';
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    style: {
      display: 'flex'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, label, ":"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, comparison !== undefined ? _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.valueLabel', {
    defaultMessage: `{value} vs {comparison}`,
    values: {
      value: valueLabel,
      comparison: comparisonLabel
    }
  }) : valueLabel, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, " ", diffLabel)))));
}