"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultsTypeField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18nReact = require("@kbn/i18n-react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/form/results_type_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SNAPSHOT_OPTION = {
  value: 'snapshot',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.resultsTypeField.snapshotValueLabel",
    defaultMessage: "Snapshot",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  })
};
const DIFFERENTIAL_OPTION = {
  value: 'differential',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.resultsTypeField.differentialValueLabel",
    defaultMessage: "Differential",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  })
};
const DIFFERENTIAL_ADDED_ONLY_OPTION = {
  value: 'added_only',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.resultsTypeField.differentialAddedOnlyValueLabel",
    defaultMessage: "Differential (Ignore removals)",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  })
};
const FIELD_OPTIONS = [SNAPSHOT_OPTION, DIFFERENTIAL_OPTION, DIFFERENTIAL_ADDED_ONLY_OPTION];
const ResultsTypeFieldComponent = ({
  euiFieldProps = {}
}) => {
  const [selectedOption, setSelectedOption] = (0, _react.useState)(SNAPSHOT_OPTION.value);
  const {
    defaultValues
  } = (0, _reactHookForm.useFormState)();
  const {
    field: {
      onChange: onSnapshotChange,
      value: snapshotValue
    }
  } = (0, _reactHookForm.useController)({
    name: 'snapshot',
    defaultValue: defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.snapshot
  });
  const {
    field: {
      onChange: onRemovedChange,
      value: removedValue
    }
  } = (0, _reactHookForm.useController)({
    name: 'removed',
    defaultValue: defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.removed
  });
  const handleChange = (0, _react.useCallback)(newValue => {
    if (newValue === SNAPSHOT_OPTION.value) {
      onSnapshotChange(true);
      onRemovedChange(false);
    }
    if (newValue === DIFFERENTIAL_OPTION.value) {
      onSnapshotChange(false);
      onRemovedChange(true);
    }
    if (newValue === DIFFERENTIAL_ADDED_ONLY_OPTION.value) {
      onSnapshotChange(false);
      onRemovedChange(false);
    }
  }, [onRemovedChange, onSnapshotChange]);
  (0, _react.useEffect)(() => {
    setSelectedOption(() => {
      if (snapshotValue) {
        return SNAPSHOT_OPTION.value;
      }
      if (!snapshotValue && removedValue) {
        return DIFFERENTIAL_OPTION.value;
      }
      if (!snapshotValue && !removedValue) {
        return DIFFERENTIAL_ADDED_ONLY_OPTION.value;
      }
      return SNAPSHOT_OPTION.value;
    });
  }, [removedValue, snapshotValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.pack.queryFlyoutForm.resultTypeFieldLabel",
      defaultMessage: "Result type",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.osquery.betaBadgeLabel', {
        defaultMessage: 'Beta'
      }),
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    }))),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.queryFlyoutForm.fieldOptionalLabel",
      defaultMessage: "(optional)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }))),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, (0, _extends2.default)({
    "data-test-subj": 'resultsTypeField',
    options: FIELD_OPTIONS,
    fullWidth: true,
    valueOfSelected: selectedOption,
    onChange: handleChange
  }, euiFieldProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  })));
};
const ResultsTypeField = exports.ResultsTypeField = /*#__PURE__*/_react.default.memo(ResultsTypeFieldComponent, _fastDeepEqual.default);