"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageIntegrationLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _kibana = require("../common/lib/kibana");
var _common2 = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/components/manage_integration_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManageIntegrationLinkComponent = () => {
  const {
    application: {
      getUrlForApp,
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const integrationHref = (0, _react.useMemo)(() => getUrlForApp(_common.INTEGRATIONS_PLUGIN_ID, {
    path: _public.pagePathGetters.integration_details_policies({
      pkgkey: _common2.OSQUERY_INTEGRATION_NAME
    })[1]
  }), [getUrlForApp]);
  const integrationClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      return navigateToApp(_common.INTEGRATIONS_PLUGIN_ID, {
        path: _public.pagePathGetters.integration_details_policies({
          pkgkey: _common2.OSQUERY_INTEGRATION_NAME
        })[1]
      });
    }
  }, [navigateToApp]);
  return integrationHref ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  },
  /*#__PURE__*/
  // eslint-disable-next-line @elastic/eui/href-or-on-click
  _react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "gear",
    href: integrationHref,
    onClick: integrationClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.appNavigation.manageIntegrationButton",
    defaultMessage: "Manage integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }))) : null;
};
const ManageIntegrationLink = exports.ManageIntegrationLink = /*#__PURE__*/_react.default.memo(ManageIntegrationLinkComponent);