"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Labels = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_tool_tags = require("../../../../hooks/tools/use_tool_tags");
var _tool_form_section = require("../components/tool_form_section");
var _i18n = require("../i18n");
var _tool_form = require("../tool_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/sections/labels.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Labels = ({
  mode
}) => {
  var _errors$labels;
  const {
    tags,
    isLoading: isLoadingTags
  } = (0, _use_tool_tags.useToolsTags)();
  const {
    control,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  const isReadOnly = mode === _tool_form.ToolFormMode.View;
  return /*#__PURE__*/_react.default.createElement(_tool_form_section.ToolFormSection, {
    title: _i18n.i18nMessages.toolLabels.documentation.title,
    icon: "tag",
    description: _i18n.i18nMessages.toolLabels.documentation.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.toolLabels.form.label,
    labelAppend: !isReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    }, _i18n.i18nMessages.optionalFieldLabel) : undefined,
    isInvalid: !!errors.labels,
    error: (_errors$labels = errors.labels) === null || _errors$labels === void 0 ? void 0 : _errors$labels.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "labels",
    render: ({
      field: {
        value,
        onChange,
        ref,
        ...field
      },
      fieldState: {
        invalid
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
      placeholder: !isReadOnly ? _i18n.i18nMessages.toolLabels.form.placeholder : undefined,
      options: tags.map(tag => ({
        label: tag
      })),
      selectedOptions: value.map(tag => ({
        label: tag
      })),
      onChange: selectedOptions => {
        onChange(selectedOptions.map(option => option.label));
      },
      onCreateOption: newTag => {
        onChange([...value, newTag]);
      },
      isClearable: true,
      isLoading: isLoadingTags,
      isInvalid: invalid,
      fullWidth: true,
      isDisabled: isReadOnly,
      inputRef: ref
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })));
};
exports.Labels = Labels;