"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationRounds = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _send_message_context = require("../../../context/send_message/send_message_context");
var _use_conversation = require("../../../hooks/use_conversation");
var _conversation_grid = require("../conversation_grid");
var _round_error = require("./round_error");
var _round_icon = require("./round_icon");
var _round_layout = require("./round_layout");
var _round_response = require("./round_response");
var _conversation_rounds = require("./conversation_rounds.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/conversation_rounds.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConversationRounds = ({
  scrollContainerHeight
}) => {
  const {
    isResponseLoading,
    retry,
    error
  } = (0, _send_message_context.useSendMessage)();
  const conversationRounds = (0, _use_conversation.useConversationRounds)();
  return /*#__PURE__*/_react.default.createElement(_conversation_grid.ConversationContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    id: _conversation_rounds.conversationRoundsId,
    direction: "column",
    gutterSize: "l",
    "aria-label": _i18n.i18n.translate('xpack.onechat.conversationRounds', {
      defaultMessage: 'Conversation messages'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, conversationRounds.map((round, index) => {
    const {
      input,
      response,
      steps
    } = round;
    const isCurrentRound = index === conversationRounds.length - 1;
    const isLoading = isResponseLoading && isCurrentRound;
    const isError = Boolean(error) && isCurrentRound;
    return /*#__PURE__*/_react.default.createElement(_round_layout.RoundLayout, {
      key: index,
      scrollContainerHeight: scrollContainerHeight
      // TODO: eventually we will use a RoundInput component when we have more complicated inputs like file attachments
      ,
      input: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 22
        }
      }, input.message),
      isResponseLoading: isResponseLoading,
      isCurrentRound: isCurrentRound,
      outputIcon: /*#__PURE__*/_react.default.createElement(_round_icon.RoundIcon, {
        isLoading: isLoading,
        isError: isError,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 27
        }
      }),
      output: isError ? /*#__PURE__*/_react.default.createElement(_round_error.RoundError, {
        error: error,
        onRetry: retry,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 19
        }
      }) : /*#__PURE__*/_react.default.createElement(_round_response.RoundResponse, {
        rawRound: round,
        response: response,
        steps: steps,
        isLoading: isLoading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 19
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    });
  })));
};
exports.ConversationRounds = ConversationRounds;