"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalResourceLinks = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _constants = require("@kbn/home-sample-data-tab/src/constants");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _support_icon = _interopRequireDefault(require("./support_icon.svg"));
var _demo_icon = _interopRequireDefault(require("./demo_icon.svg"));
var _docs_icon = _interopRequireDefault(require("./docs_icon.svg"));
var _forum_icon = _interopRequireDefault(require("./forum_icon.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/external_resource_links/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const URL_FORUM = 'https://discuss.elastic.co/';
const ExternalResourceLinks = () => {
  const {
    services: {
      docLinks,
      chrome
    }
  } = (0, _public.useKibana)();
  const helpSupportUrl = (0, _useObservable.default)(chrome.getHelpSupportUrl$());
  const sections = [{
    iconUrl: _demo_icon.default,
    title: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.demoEnvironmentFlexItemLabel', {
      defaultMessage: 'Demo environment'
    }),
    description: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.demoEnvironmentFlexItemDescription', {
      defaultMessage: 'Explore our live demo environment'
    }),
    linkLabel: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.demoEnvironmentFlexItemLinkLabel', {
      defaultMessage: 'Explore demo'
    }),
    link: _constants.URL_DEMO_ENV,
    testSubject: 'observabilityOnboardingFooterExploreDemoLink'
  }, {
    iconUrl: _forum_icon.default,
    title: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.exploreForumFlexItemLabel', {
      defaultMessage: 'Explore forum'
    }),
    description: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.exploreForumFlexItemDescription', {
      defaultMessage: 'Exchange thoughts about Elastic'
    }),
    linkLabel: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.exploreForumFlexItemLinkLabel', {
      defaultMessage: 'Discuss forum'
    }),
    linkARIALabel: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.exploreForumFlexItemLinkARIALabel', {
      defaultMessage: 'Discuss forum. Open Elastic forum'
    }),
    link: URL_FORUM,
    testSubject: 'observabilityOnboardingFooterDiscussForumLink'
  }, {
    iconUrl: _docs_icon.default,
    title: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.browseDocumentationFlexItemLabel', {
      defaultMessage: 'Browse documentation'
    }),
    description: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.browseDocumentationFlexItemDescription', {
      defaultMessage: 'In-depth guides on all Elastic features'
    }),
    linkLabel: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.browseDocumentationFlexItemLinkLabel', {
      defaultMessage: 'Learn more'
    }),
    linkARIALabel: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.browseDocumentationFlexItemLinkARIALabel', {
      defaultMessage: 'Learn more about all Elastic features'
    }),
    link: docLinks.links.observability.guide,
    testSubject: 'observabilityOnboardingFooterLearnMoreLink'
  }, {
    iconUrl: _support_icon.default,
    title: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.supportHubFlexItemLabel', {
      defaultMessage: 'Support Hub'
    }),
    description: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.supportHubFlexItemDescription', {
      defaultMessage: 'Get help by opening a case'
    }),
    linkLabel: _i18n.i18n.translate('xpack.observabilityShared.experimentalOnboardingFlow.supportHubFlexItemLinkLabel', {
      defaultMessage: 'Open Support Hub'
    }),
    link: helpSupportUrl,
    testSubject: 'observabilityOnboardingFooterOpenSupportHubLink'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, sections.map((section, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: "l",
    name: "",
    imageUrl: section.iconUrl,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, section.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, section.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": section.testSubject,
    "aria-label": section.linkARIALabel,
    href: section.link,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }, section.linkLabel))))));
};
exports.ExternalResourceLinks = ExternalResourceLinks;