"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsRulesTypeAlertDefinition = void 0;
exports.thresholdRuleType = thresholdRuleType;
var _server = require("@kbn/core/server");
var _common = require("@kbn/data-plugin/common");
var _i18n = require("@kbn/i18n");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _custom_threshold = require("@kbn/response-ops-rule-params/custom_threshold");
var _common2 = require("../../../../common");
var _constants = require("../../../common/constants");
var _translations = require("./translations");
var _custom_threshold_executor = require("./custom_threshold_executor");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsRulesTypeAlertDefinition = exports.MetricsRulesTypeAlertDefinition = {
  context: _constants.THRESHOLD_RULE_REGISTRATION_CONTEXT,
  mappings: {
    fieldMap: _alertsAsDataUtils.legacyExperimentalFieldMap,
    dynamicTemplates: [{
      strings_as_keywords: {
        path_match: 'kibana.alert.grouping.*',
        match_mapping_type: 'string',
        mapping: {
          type: 'keyword',
          ignore_above: 1024
        }
      }
    }]
  },
  useEcs: true,
  useLegacyAlerts: false,
  shouldWrite: true
};
function thresholdRuleType(basePath, config, logger, locators) {
  return {
    id: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
    name: _i18n.i18n.translate('xpack.observability.threshold.ruleName', {
      defaultMessage: 'Custom threshold'
    }),
    validate: {
      params: _custom_threshold.customThresholdParamsSchema
    },
    schemas: {
      params: {
        type: 'config-schema',
        schema: _custom_threshold.customThresholdParamsSchema
      }
    },
    defaultActionGroupId: _constants2.FIRED_ACTION.id,
    actionGroups: [_constants2.FIRED_ACTION, _constants2.NO_DATA_ACTION],
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: (0, _custom_threshold_executor.createCustomThresholdExecutor)({
      basePath,
      logger,
      config,
      locators
    }),
    doesSetRecoveryContext: true,
    actionVariables: {
      context: [{
        name: 'group',
        description: _translations.groupActionVariableDescription
      }, {
        name: 'grouping',
        description: _translations.groupingObjectActionVariableDescription
      }, {
        name: 'alertDetailsUrl',
        description: _translations.alertDetailUrlActionVariableDescription,
        usesPublicBaseUrl: true
      }, {
        name: 'reason',
        description: _translations.reasonActionVariableDescription
      }, {
        name: 'timestamp',
        description: _translations.timestampActionVariableDescription
      }, {
        name: 'value',
        description: _translations.valueActionVariableDescription
      }, {
        name: 'cloud',
        description: _translations.cloudActionVariableDescription
      }, {
        name: 'host',
        description: _translations.hostActionVariableDescription
      }, {
        name: 'container',
        description: _translations.containerActionVariableDescription
      }, {
        name: 'orchestrator',
        description: _translations.orchestratorActionVariableDescription
      }, {
        name: 'labels',
        description: _translations.labelsActionVariableDescription
      }, {
        name: 'tags',
        description: _translations.tagsActionVariableDescription
      }, {
        name: 'viewInAppUrl',
        description: _translations.viewInAppUrlActionVariableDescription
      }]
    },
    useSavedObjectReferences: {
      // TODO revisit types https://github.com/elastic/kibana/issues/159714
      extractReferences: params => {
        const [searchConfiguration, references] = (0, _common.extractReferences)(params.searchConfiguration);
        const newParams = {
          ...params,
          searchConfiguration
        };
        return {
          params: newParams,
          references
        };
      },
      injectReferences: (params, references) => {
        return {
          ...params,
          searchConfiguration: (0, _common.injectReferences)(params.searchConfiguration, references)
        };
      }
    },
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: _common2.observabilityFeatureId,
    solution: 'observability',
    alerts: MetricsRulesTypeAlertDefinition,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common2.observabilityPaths.ruleDetails(rule.id)
  };
}