"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsListChart = AnnotationsListChart;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _reactReversePortal = require("react-reverse-portal");
var _i18n = require("@kbn/i18n");
var _datemath = require("@kbn/datemath");
var _moment = _interopRequireDefault(require("moment"));
var _use_chart_themes = require("../../hooks/use_chart_themes");
var _create_annotation_btn = require("./create_annotation_btn");
var _use_annotations = require("../../components/annotations/use_annotations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/annotations/annotations_list_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AnnotationsListChart({
  data,
  start,
  end,
  isEditing,
  setIsEditing,
  permissions
}) {
  const {
    ObservabilityAnnotations,
    createAnnotation,
    onAnnotationClick
  } = (0, _use_annotations.useAnnotations)({
    editAnnotation: isEditing,
    setEditAnnotation: setIsEditing
  });
  const brushEndListener = ({
    x
  }) => {
    if (!x) {
      return;
    }
    const startX = x[0];
    const endX = x[1];
    createAnnotation(String(startX), String(endX));
  };
  const domain = (0, _react.useMemo)(() => {
    var _parse, _parse2;
    return {
      min: (_parse = (0, _datemath.parse)(start)) === null || _parse === void 0 ? void 0 : _parse.valueOf(),
      max: (_parse2 = (0, _datemath.parse)(end, {
        roundUp: true
      })) === null || _parse2 === void 0 ? void 0 : _parse2.valueOf()
    };
  }, [end, start]);
  // we need at least two points for chart to render

  const domainPoints =
  // we need at least two points for chart to render
  [{
    x: domain.min,
    y: 1
  }, {
    x: domain.min + 1,
    y: 1
  }, {
    x: domain.min + 1,
    y: 1
  }, {
    x: domain.max,
    y: 1
  }];
  const {
    baseTheme
  } = (0, _use_chart_themes.useChartThemes)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: _create_annotation_btn.createAnnotationPortal,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !(permissions !== null && permissions !== void 0 && permissions.write) ? _i18n.i18n.translate('xpack.observability.createAnnotation.missingPermissions', {
      defaultMessage: 'You do not have permission to create annotations'
    }) : '',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: !(permissions !== null && permissions !== void 0 && permissions.write),
    "data-test-subj": "o11yRenderToolsRightCreateAnnotationButton",
    key: "createAnnotation",
    onClick: () => {
      createAnnotation((0, _moment.default)().subtract(1, 'day').toISOString());
    },
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability.renderToolsRight.createAnnotationButtonLabel', {
    defaultMessage: 'Create annotation'
  })))), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onElementClick: ([geometry, _]) => {
      var _point$;
      const point = geometry;
      if (!point) return;
      createAnnotation((_point$ = point[0]) === null || _point$ === void 0 ? void 0 : _point$.x);
    },
    onBrushEnd: brushEndListener,
    onAnnotationClick: onAnnotationClick,
    xDomain: domain,
    baseTheme: baseTheme,
    theme: {
      chartMargins: {
        top: 50
      },
      barSeriesStyle: {
        rect: {
          opacity: 0
        }
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(ObservabilityAnnotations, {
    annotations: data,
    tooltipSpecs: {
      customTooltip: props => /*#__PURE__*/_react.default.createElement(Tooltip, (0, _extends2.default)({}, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 39
        }
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "horizontal",
    position: _charts.Position.Bottom,
    title: _i18n.i18n.translate('xpack.observability.annotationsListChart.axis.timestampLabel', {
      defaultMessage: '@timestamp'
    }),
    tickFormat: d => (0, _eui.formatDate)(d, 'longDateTime'),
    groupId: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "vertical",
    title: _i18n.i18n.translate('xpack.observability.annotationsListChart.axis.yDomainLabel', {
      defaultMessage: 'Y Domain'
    }),
    position: _charts.Position.Left,
    hide: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "bars"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    data: domainPoints,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }));
}
function Tooltip({
  header,
  values
}) {
  return /*#__PURE__*/_react.default.createElement(_charts.TooltipContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, header === null || header === void 0 ? void 0 : header.formattedValue), /*#__PURE__*/_react.default.createElement(_charts.TooltipTable, {
    columns: [{
      type: 'color'
    }, {
      type: 'text',
      cell: t => _i18n.i18n.translate('xpack.observability.tooltip.p.clickToAddAnnotationLabel', {
        defaultMessage: 'Click to add annotation'
      }),
      style: {
        textAlign: 'left'
      }
    }],
    items: values,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }));
}