"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardTile = DashboardTile;
var _react = _interopRequireDefault(require("react"));
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _eui = require("@elastic/eui");
var _kibana_react = require("../../../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/related_dashboards/dashboard_tile.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DashboardTile({
  dashboard,
  actionButtonProps,
  timeRange
}) {
  const {
    services: {
      telemetryClient,
      share: {
        url: urlService
      },
      savedObjectsTagging: {
        ui: savedObjectsTaggingUi
      }
    }
  } = (0, _kibana_react.useKibana)();
  const dashboardLocator = urlService.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const tagsReferences = (dashboard.tags || []).flatMap(tag => {
    const ref = savedObjectsTaggingUi.convertNameToReference(tag);
    return ref ? [{
      ...ref,
      name: tag
    }] : [];
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    key: dashboard.id,
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: dashboard.id,
    gutterSize: "s",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `alertDetails_viewLinkedDashboard_${actionButtonProps === null || actionButtonProps === void 0 ? void 0 : actionButtonProps.ruleType}`,
    href: dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
      dashboardId: dashboard.id,
      timeRange
    }),
    target: "_blank",
    onClick: () => {
      if (telemetryClient) {
        telemetryClient.reportLinkedDashboardViewed((actionButtonProps === null || actionButtonProps === void 0 ? void 0 : actionButtonProps.ruleType) || 'unknown');
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, dashboard.title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: 'subdued',
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, dashboard.description), tagsReferences.length ? /*#__PURE__*/_react.default.createElement(savedObjectsTaggingUi.components.TagList, {
    object: {
      references: tagsReferences
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }) : null), actionButtonProps ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `addSuggestedDashboard_alertDetailsPage_${actionButtonProps.ruleType}`,
    onClick: () => {
      actionButtonProps.onClick(dashboard);
      telemetryClient.reportSuggestedDashboardAdded(actionButtonProps.ruleType);
    },
    isLoading: actionButtonProps.isLoading,
    isDisabled: actionButtonProps.isDisabled,
    iconType: "plus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, actionButtonProps.label))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }));
}