"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataFetcher = void 0;
var _react = require("react");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataFetcher = ({
  paramsForApiCall,
  initialDataState,
  executeApiCall,
  shouldExecuteApiCall
}) => {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(false);
  const [data, setData] = (0, _react.useState)(initialDataState);
  const {
    fetch,
    cancel
  } = (0, _react.useMemo)(() => {
    const abortController = new AbortController();
    let isCanceled = false;
    return {
      fetch: async () => {
        if (shouldExecuteApiCall(paramsForApiCall)) {
          setError(false);
          setLoading(true);
          try {
            const results = await executeApiCall(paramsForApiCall, abortController, http);
            if (!isCanceled) {
              setLoading(false);
              setData(results);
            }
          } catch (e) {
            setError(true);
            setLoading(false);
          }
        }
      },
      cancel: () => {
        isCanceled = true;
        abortController.abort();
      }
    };
  }, [executeApiCall, http, paramsForApiCall, shouldExecuteApiCall]);
  (0, _react.useEffect)(() => {
    fetch();
    return () => {
      cancel();
    };
  }, [fetch, cancel]);
  return {
    data,
    loading,
    error
  };
};
exports.useDataFetcher = useDataFetcher;