"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnnotations = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _moment = _interopRequireDefault(require("moment"));
var _useKey = _interopRequireDefault(require("react-use/lib/useKey"));
var _lodash = require("lodash");
var _default_annotation = require("./default_annotation");
var _use_edit_annotation_helper = require("./hooks/use_edit_annotation_helper");
var _components = require("./components");
var _use_fetch_annotations = require("./hooks/use_fetch_annotations");
var _use_annotation_cruds = require("./hooks/use_annotation_cruds");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/use_annotations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useAnnotations = ({
  domain,
  editAnnotation,
  slo,
  setEditAnnotation
} = {}) => {
  var _data$items;
  const [isCreateOpen, setIsCreateOpen] = (0, _react.useState)(false);
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: (0, _default_annotation.getDefaultAnnotation)({
      slo
    }),
    mode: 'all'
  });
  const {
    setValue,
    reset
  } = methods;
  const [isCtrlPressed, setIsCtrlPressed] = (0, _react.useState)(false);
  const [selectedEditAnnotation, setSelectedEditAnnotation] = (0, _react.useState)(null);
  const {
    data,
    refetch
  } = (0, _use_fetch_annotations.useFetchAnnotations)({
    start: domain !== null && domain !== void 0 && domain.min ? String(domain === null || domain === void 0 ? void 0 : domain.min) : 'now-30d',
    end: domain !== null && domain !== void 0 && domain.min ? String(domain === null || domain === void 0 ? void 0 : domain.max) : 'now',
    slo
  });
  (0, _useKey.default)(event => event.metaKey, event => {
    setIsCtrlPressed(event.type === 'keydown');
  });
  (0, _use_edit_annotation_helper.useEditAnnotationHelper)({
    reset,
    editAnnotation,
    setIsCreateOpen
  });
  const onCancel = (0, _react.useCallback)(() => {
    setValue('event.end', null);
    setIsCreateOpen(false);
    setSelectedEditAnnotation(null);
    setEditAnnotation === null || setEditAnnotation === void 0 ? void 0 : setEditAnnotation(null);
  }, [setEditAnnotation, setValue]);
  const {
    createAnnotation,
    updateAnnotation,
    deleteAnnotation,
    isLoading
  } = (0, _use_annotation_cruds.useAnnotationCRUDS)();
  const AddAnnotationButton = (0, _react.useMemo)(() => {
    if (!isCreateOpen) return () => null;
    return () => /*#__PURE__*/_react.default.createElement(_components.CreateAnnotation, {
      onSave: () => {
        setIsCreateOpen(false);
        refetch();
      },
      onCancel: onCancel,
      editAnnotation: editAnnotation !== null && editAnnotation !== void 0 ? editAnnotation : selectedEditAnnotation,
      isCreateAnnotationsOpen: isCreateOpen,
      createAnnotation: createAnnotation,
      updateAnnotation: updateAnnotation,
      deleteAnnotation: deleteAnnotation,
      isLoading: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    });
  }, [createAnnotation, deleteAnnotation, editAnnotation, isCreateOpen, isLoading, onCancel, refetch, selectedEditAnnotation, updateAnnotation]);
  return {
    annotations: (_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [],
    onAnnotationClick: annotations => {
      if (annotations.rects.length) {
        var _data$items2;
        const selectedAnnotation = data === null || data === void 0 ? void 0 : (_data$items2 = data.items) === null || _data$items2 === void 0 ? void 0 : _data$items2.find(a => annotations.rects[0].id.includes(a.id));
        if (selectedAnnotation) {
          const editData = (0, _lodash.clone)(selectedAnnotation);
          reset({
            ...editData,
            '@timestamp': (0, _moment.default)(editData['@timestamp']),
            event: {
              end: editData.event ? (0, _moment.default)(editData.event.end) : undefined,
              start: (0, _moment.default)(editData['@timestamp'])
            }
          });
          setIsCreateOpen(true);
          setSelectedEditAnnotation(editData);
        }
      }
      if (annotations.lines.length) {
        var _data$items3;
        const selectedAnnotation = data === null || data === void 0 ? void 0 : (_data$items3 = data.items) === null || _data$items3 === void 0 ? void 0 : _data$items3.find(a => annotations.lines[0].id.includes(a.id));
        if (selectedAnnotation) {
          const editData = (0, _lodash.clone)(selectedAnnotation);
          reset({
            ...editData,
            '@timestamp': (0, _moment.default)(editData['@timestamp'])
          });
          setSelectedEditAnnotation(editData);
          setIsCreateOpen(true);
        }
      }
    },
    wrapOnBrushEnd: originalHandler => {
      return event => {
        if (isCtrlPressed) {
          setSelectedEditAnnotation(null);
          const {
            to,
            from
          } = getBrushData(event);
          reset((0, _default_annotation.getDefaultAnnotation)({
            slo,
            timestamp: (0, _moment.default)(from),
            eventEnd: (0, _moment.default)(to)
          }));
          setIsCreateOpen(true);
        } else {
          // Call the original handler
          originalHandler === null || originalHandler === void 0 ? void 0 : originalHandler(event);
        }
      };
    },
    createAnnotation: (start, end) => {
      if (isCreateOpen) return;
      const timestampStart = isNaN(Number(start)) ? (0, _moment.default)(start) : (0, _moment.default)(new Date(Number(start)));
      reset((0, _default_annotation.getDefaultAnnotation)({
        slo,
        timestamp: timestampStart,
        eventEnd: end ? (0, _moment.default)(new Date(Number(end))) : undefined
      }));
      setIsCreateOpen(true);
    },
    AddAnnotationButton: () => {
      return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, methods, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(AddAnnotationButton, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 11
        }
      }));
    },
    ObservabilityAnnotations: ({
      tooltipSpecs,
      annotations
    }) => {
      return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, methods, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_components.ObservabilityAnnotations, {
        tooltipSpecs: tooltipSpecs,
        annotations: annotations,
        slo: slo,
        isCreateOpen: isCreateOpen,
        setIsCreateOpen: setIsCreateOpen,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(AddAnnotationButton, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 11
        }
      }));
    }
  };
};
exports.useAnnotations = useAnnotations;
function getBrushData(e) {
  var _e$x, _e$x2;
  const [from, to] = [Number((_e$x = e.x) === null || _e$x === void 0 ? void 0 : _e$x[0]), Number((_e$x2 = e.x) === null || _e$x2 === void 0 ? void 0 : _e$x2[1])];
  const [fromUtc, toUtc] = [(0, _moment.default)(from).format(), (0, _moment.default)(to).format()];
  return {
    from: fromUtc,
    to: toUtc
  };
}