"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyout = AlertsFlyout;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _translations = require("@kbn/response-ops-alerts-table/translations");
var _format_alert_title = require("../../utils/format_alert_title");
var _parse_alert = require("../../pages/alerts/helpers/parse_alert");
var _paths = require("../../../common/locators/paths");
var _alert_overview = require("../alert_overview/alert_overview");
var _kibana_react = require("../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alerts_flyout/alerts_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AlertsFlyout({
  alert,
  isLoading,
  tableId,
  onClose,
  observabilityRuleTypeRegistry,
  headerAppend
}) {
  var _alert$ALERT_RULE_CAT, _alert$ALERT_RULE_NAM;
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const parsedAlert = alert ? (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(alert) : null;
  const overviewTab = (0, _react.useMemo)(() => {
    return {
      id: 'overview',
      'data-test-subj': 'observabilityAlertFlyoutOverviewTab',
      name: _i18n.i18n.translate('xpack.observability.alertFlyout.overview', {
        defaultMessage: 'Overview'
      }),
      content: parsedAlert && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasShadow: false,
        "data-test-subj": "observabilityAlertFlyoutOverviewTabPanel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_alert_overview.AlertOverview, {
        alert: parsedAlert,
        pageId: tableId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 11
        }
      }))
    };
  }, [parsedAlert, tableId]);
  const metadataTab = (0, _react.useMemo)(() => ({
    id: 'metadata',
    'data-test-subj': 'observabilityAlertFlyoutMetadataTab',
    name: _i18n.i18n.translate('xpack.observability.alertsFlyout.metadata', {
      defaultMessage: 'Metadata'
    }),
    content: alert && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      "data-test-subj": "observabilityAlertFlyoutMetadataTabPanel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_alertsUiShared.AlertFieldsTable, {
      alert: alert,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }))
  }), [alert]);
  const tabs = (0, _react.useMemo)(() => [overviewTab, metadataTab], [overviewTab, metadataTab]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)('overview');
  const handleTabClick = (0, _react.useCallback)(tab => setSelectedTabId(tab.id), []);
  const selectedTab = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  }, [tabs, selectedTabId]);
  const viewInAppUrl = (0, _react.useMemo)(() => {
    if (!parsedAlert) {
      return undefined;
    }
    if (!parsedAlert.hasBasePath) {
      var _parsedAlert$link;
      return prepend((_parsedAlert$link = parsedAlert.link) !== null && _parsedAlert$link !== void 0 ? _parsedAlert$link : '');
    }
    return parsedAlert.link;
  }, [parsedAlert, prepend]);
  const ariaLabel = alert && alert[_ruleDataUtils.ALERT_RULE_CATEGORY] ? (0, _translations.getAlertFlyoutAriaLabel)(String(alert[_ruleDataUtils.ALERT_RULE_CATEGORY])) : _translations.ALERT_FLYOUT_DEFAULT_TITLE;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    className: "oblt__flyout",
    onClose: onClose,
    size: "m",
    "data-test-subj": "alertsFlyout",
    "aria-label": ariaLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "alertsFlyoutTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, alert ? (0, _format_alert_title.getAlertTitle)((_alert$ALERT_RULE_CAT = alert[_ruleDataUtils.ALERT_RULE_CATEGORY]) === null || _alert$ALERT_RULE_CAT === void 0 ? void 0 : _alert$ALERT_RULE_CAT[0]) : _i18n.i18n.translate('xpack.observability.alertFlyout.defaultTitle', {
    defaultMessage: 'Alert detail'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }), (alert === null || alert === void 0 ? void 0 : alert[_ruleDataUtils.ALERT_RULE_NAME]) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.alertFlyout.title.ruleName",
    defaultMessage: "Rule",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }, (_alert$ALERT_RULE_NAM = alert[_ruleDataUtils.ALERT_RULE_NAME]) === null || _alert$ALERT_RULE_NAM === void 0 ? void 0 : _alert$ALERT_RULE_NAM[0])), headerAppend), isLoading ?
  /*#__PURE__*/
  // Display a loading indicator if a new page is being loaded
  _react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    "data-test-subj": "alertFlyoutLoading",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }))) : alert && /*#__PURE__*/_react.default.createElement(_alertsUiShared.ScrollableFlyoutTabbedContent, {
    tabs: tabs,
    selectedTab: selectedTab,
    onTabClick: handleTabClick,
    expand: true,
    "data-test-subj": "alertFlyoutTabs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }), parsedAlert && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }, !parsedAlert.link || tableId === _common.SLO_ALERTS_TABLE_ID ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "alertsFlyoutViewInAppButton",
    fill: true,
    href: viewInAppUrl,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.viewInAppButtonText', {
    defaultMessage: 'View in app'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "alertsFlyoutAlertDetailsButton",
    fill: true,
    href: prepend && prepend(_paths.paths.observability.alertDetails(parsedAlert.fields['kibana.alert.uuid'])),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.alertsDetailsButtonText', {
    defaultMessage: 'Alert details'
  }))))));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AlertsFlyout;