"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ebtTools = require("@kbn/ebt-tools");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _empty_prompt = require("../shared/empty_prompt");
var _command_snippet = require("./command_snippet");
var _data_ingest_status = require("./data_ingest_status");
var _feedback_buttons = require("../shared/feedback_buttons");
var _use_kubernetes_flow = require("./use_kubernetes_flow");
var _use_window_blur_data_monitoring_trigger = require("../shared/use_window_blur_data_monitoring_trigger");
var _use_flow_breadcrumbs = require("../../shared/use_flow_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/kubernetes/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KubernetesPanel = () => {
  (0, _use_flow_breadcrumbs.useFlowBreadcrumb)({
    text: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.breadcrumbs.k8s', {
      defaultMessage: 'Kubernetes: Logs & Metrics'
    })
  });
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_kubernetes_flow.useKubernetesFlow)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const isMonitoringStepActive = (0, _use_window_blur_data_monitoring_trigger.useWindowBlurDataMonitoringTrigger)({
    isActive: status === _use_fetcher.FETCH_STATUS.SUCCESS,
    onboardingFlowType: 'kubernetes',
    onboardingId: data === null || data === void 0 ? void 0 : data.onboardingId
  });
  (0, _react.useEffect)(() => {
    if (data) {
      onPageReady({
        meta: {
          description: `[ttfmp_onboarding] Request to create the onboarding flow succeeded and the flow's UI has rendered`
        }
      });
    }
  }, [data, onPageReady]);
  if (error !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      onboardingFlowType: "kubernetes",
      error: error,
      onRetryClick: refetch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 12
      }
    });
  }
  const steps = [{
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.kubernetes.installStepTitle', {
      defaultMessage: 'Install standalone Elastic Agent on your Kubernetes cluster'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, status !== _use_fetcher.FETCH_STATUS.SUCCESS && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 5,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "170px",
      height: "40px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    })), status === _use_fetcher.FETCH_STATUS.SUCCESS && data !== undefined && /*#__PURE__*/_react.default.createElement(_command_snippet.CommandSnippet, {
      encodedApiKey: data.apiKeyEncoded,
      onboardingId: data.onboardingId,
      elasticsearchUrl: data.elasticsearchUrl,
      elasticAgentVersionInfo: data.elasticAgentVersionInfo,
      isCopyPrimaryAction: !isMonitoringStepActive,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }))
  }, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.kubernetes.monitorStepTitle', {
      defaultMessage: 'Monitor your Kubernetes cluster'
    }),
    status: isMonitoringStepActive ? 'current' : 'incomplete',
    children: isMonitoringStepActive && data && /*#__PURE__*/_react.default.createElement(_data_ingest_status.DataIngestStatus, {
      onboardingId: data.onboardingId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
    flow: "kubernetes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }));
};
exports.KubernetesPanel = KubernetesPanel;