"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMonitoringTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatting = require("../setup_mode/formatting");
var _setup_mode = require("../../lib/setup_mode");
var _enums = require("../../../common/enums");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/table/eui_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EuiMonitoringTable = ({
  rows: items,
  search = {},
  columns: _columns,
  setupMode,
  productName,
  ...props
}) => {
  const [hasItems, setHasItem] = _react.default.useState(items.length > 0);
  if (search.box && !search.box['data-test-subj']) {
    search.box['data-test-subj'] = 'monitoringTableToolBar';
  }
  if (search.box && !search.box.schema) {
    search.box.schema = true;
  }
  if (search) {
    const oldOnChange = search.onChange;
    search.onChange = arg => {
      const filteredItems = _eui.EuiSearchBar.Query.execute(arg.query, items, props.executeQueryOptions);
      setHasItem(filteredItems.length > 0);
      if (oldOnChange) {
        oldOnChange(arg);
      }
      return true;
    };
  }
  const columns = _columns.map(column => {
    if (!('sortable' in column)) {
      column.sortable = true;
    }
    return column;
  });
  let footerContent = null;
  if (setupMode && (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
    footerContent = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "flag",
      onClick: () => setupMode.openFlyout({}, true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.monitoring.euiTable.setupNewButtonLabel', {
      defaultMessage: 'Monitor another {identifier} with Metricbeat',
      values: {
        identifier: (0, _formatting.getIdentifier)(productName)
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${props['data-test-subj']}Container`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({
    items: items,
    search: search,
    columns: columns
  }, props, {
    "data-test-subj": items.length && hasItems ? 'monitoringTableHasData' : 'monitoringTableNoData',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  })), footerContent);
};
exports.EuiMonitoringTable = EuiMonitoringTable;