"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultStatusIndicator = void 0;
exports.SummaryStatus = SummaryStatus;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _status_icon = require("../status_icon");
var _status = require("../../alerts/status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/summary_status/summary_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const summaryStatusNoWrapStyle = ({
  euiTheme
}) => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('margin-left', euiTheme.size.m)}
  ${(0, _eui.logicalCSS)('margin-right', euiTheme.size.m)}
`;
const summaryStatusNoWrapStatStyle = (0, _react2.css)`
  p {
    ${(0, _eui.euiTextTruncate)()}
  }
`;
const wrapChild = ({
  label,
  value,
  ...props
}, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, (0, _extends2.default)({
  style: {
    maxWidth: 200
  },
  key: `summary-status-item-${index}`,
  grow: false
}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 3
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
  title: value,
  css: summaryStatusNoWrapStatStyle,
  titleSize: "xxxs",
  textAlign: "left",
  description: label ? `${label}` : '',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 5
  }
}));
const DefaultIconComponent = ({
  status
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.monitoring.summaryStatus.statusIconTitle",
  defaultMessage: "Status: {statusIcon}",
  values: {
    statusIcon: /*#__PURE__*/_react.default.createElement(_status_icon.StatusIcon, {
      type: status.toUpperCase(),
      label: _i18n.i18n.translate('xpack.monitoring.summaryStatus.statusIconLabel', {
        defaultMessage: 'Status: {status}',
        values: {
          status
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    })
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 5
  }
}));
const DefaultStatusIndicator = ({
  status,
  IconComponent,
  isOnline = false
}) => {
  if (!(status !== null && status !== void 0 && status.length)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "status",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(IconComponent, {
      status: status,
      isOnline: isOnline,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    }), "\xA0", (0, _lodash.capitalize)(status)),
    titleSize: "xxxs",
    textAlign: "left",
    css: summaryStatusNoWrapStatStyle,
    description: _i18n.i18n.translate('xpack.monitoring.summaryStatus.statusDescription', {
      defaultMessage: 'Status'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  });
};
exports.DefaultStatusIndicator = DefaultStatusIndicator;
function SummaryStatus({
  metrics,
  alerts,
  status,
  isOnline = false,
  IconComponent = DefaultIconComponent,
  StatusIndicator = DefaultStatusIndicator,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, props, {
    css: summaryStatusNoWrapStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textTruncate",
    style: {
      maxWidth: 200
    },
    key: `summary-status-item-status`,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StatusIndicator, {
    status: status,
    isOnline: isOnline,
    IconComponent: IconComponent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  })), alerts ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
      showOnlyCount: true,
      alerts: alerts,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 22
      }
    }),
    titleSize: "xxxs",
    textAlign: "left",
    css: summaryStatusNoWrapStatStyle,
    description: _i18n.i18n.translate('xpack.monitoring.summaryStatus.alertsDescription', {
      defaultMessage: 'Alerts'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  })) : null, metrics.map(wrapChild)));
}