"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringToolbar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _use_monitoring_time = require("../../application/hooks/use_monitoring_time");
var _global_state_context = require("../../application/contexts/global_state_context");
var _legacy_shims = require("../../legacy_shims");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/shared/toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitoringToolbar = ({
  pageTitle,
  onRefresh
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const timePickerQuickRanges = services.uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const commonlyUsedRanges = (0, _react.useMemo)(() => timePickerQuickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  })), [timePickerQuickRanges]);
  const {
    currentTimerange,
    handleTimeChange,
    setRefreshInterval,
    refreshInterval,
    setIsPaused,
    isPaused,
    isDisabled
  } = (0, _use_monitoring_time.useMonitoringTimeContainerContext)();
  const state = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const onTimeChange = (0, _react.useCallback)(selectedTime => {
    if (selectedTime.isInvalid) {
      return;
    }
    handleTimeChange(selectedTime.start, selectedTime.end);
  }, [handleTimeChange]);
  const onRefreshChange = (0, _react.useCallback)(({
    refreshInterval: ri,
    isPaused: isP
  }) => {
    var _state$save;
    setRefreshInterval(ri);
    setIsPaused(isP);
    state.refreshInterval = {
      pause: isP,
      value: ri
    };
    _legacy_shims.Legacy.shims.timefilter.setRefreshInterval(state.refreshInterval);
    (_state$save = state.save) === null || _state$save === void 0 ? void 0 : _state$save.call(state);
  }, [setRefreshInterval, setIsPaused, state]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: pageTitle,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
      isDisabled: isDisabled,
      start: currentTimerange.from,
      end: currentTimerange.to,
      onTimeChange: onTimeChange,
      onRefresh: onRefresh,
      isPaused: isPaused,
      refreshInterval: refreshInterval,
      onRefreshChange: onRefreshChange,
      commonlyUsedRanges: commonlyUsedRanges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  });
};
exports.MonitoringToolbar = MonitoringToolbar;