"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmPanel = ApmPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _format_number = require("../../../lib/format_number");
var _helpers = require("./helpers");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _constants = require("../../../../common/constants");
var _tooltip = require("../../setup_mode/tooltip");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _setup_mode = require("../../../lib/setup_mode");
var _enums = require("../../../../common/enums");
var _apm_agent = require("../../../lib/apm_agent");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/cluster/overview/apm_panel.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getServerTitle = (isFleetTypeMetric, total) => {
  const apmsTotal = /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "apmsTotal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 21
    }
  }, total);
  const linkLabel = {};
  if (isFleetTypeMetric) {
    linkLabel.link = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.cluster.overview.apmPanel.agentServersTotalLinkLabel",
      defaultMessage: "Integrations Servers: {apmsTotal}",
      values: {
        apmsTotal
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    });
    linkLabel.aria = _i18n.i18n.translate('xpack.monitoring.cluster.overview.apmPanel.instancesAndFleetsTotalLinkAriaLabel', {
      defaultMessage: 'Integrations server instances: {apmsTotal}',
      values: {
        apmsTotal
      }
    });
    return linkLabel;
  }
  linkLabel.link = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.apmPanel.serversTotalLinkLabel",
    defaultMessage: "APM servers: {apmsTotal}",
    values: {
      apmsTotal
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
  linkLabel.aria = _i18n.i18n.translate('xpack.monitoring.cluster.overview.apmPanel.instancesTotalLinkAriaLabel', {
    defaultMessage: 'APM server instances: {apmsTotal}',
    values: {
      apmsTotal
    }
  });
  return linkLabel;
};
const getOverviewTitle = isFleetTypeMetric => {
  if (isFleetTypeMetric) {
    return _i18n.i18n.translate('xpack.monitoring.cluster.overview.apmPanel.overviewFleetLinkLabel', {
      defaultMessage: 'Integrations server overview'
    });
  }
  return _i18n.i18n.translate('xpack.monitoring.cluster.overview.apmPanel.overviewLinkLabel', {
    defaultMessage: 'APM server overview'
  });
};
const getHeadingTitle = isFleetTypeMetric => {
  if (isFleetTypeMetric) {
    return _i18n.i18n.translate('xpack.monitoring.cluster.overview.apmPanel.apmFleetTitle', {
      defaultMessage: 'Integrations server'
    });
  }
  return _i18n.i18n.translate('xpack.monitoring.cluster.overview.apmPanel.apmTitle', {
    defaultMessage: 'APM server'
  });
};
function ApmPanel(props) {
  const {
    setupMode,
    versions
  } = props;
  const apmsTotal = (0, _lodash.get)(props, 'apms.total') || 0;
  // Do not show if we are not in setup mode
  if (apmsTotal === 0 && !setupMode.enabled) {
    return null;
  }
  const isFleetTypeMetric = (0, _apm_agent.checkAgentTypeMetric)(versions);
  const {
    link,
    aria
  } = getServerTitle(isFleetTypeMetric, apmsTotal);
  const overviewTitle = getOverviewTitle(isFleetTypeMetric);
  const goToInstances = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/apm/instances');
  const setupModeData = (0, _lodash.get)(setupMode.data, 'apm');
  const setupModeMetricbeatMigrationTooltip = (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration) ? /*#__PURE__*/_react.default.createElement(_tooltip.SetupModeTooltip, {
    setupModeData: setupModeData,
    badgeClickLink: goToInstances(),
    productName: _constants.APM_SYSTEM_ID,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_helpers.ClusterItemContainer, (0, _extends2.default)({}, props, {
    url: "apm",
    title: getHeadingTitle(isFleetTypeMetric),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: (0, _get_safe_for_external_link.getSafeForExternalLink)('#/apm'),
    "aria-label": overviewTitle,
    "data-test-subj": "apmOverview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }, overviewTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.apmPanel.processedEventsLabel",
    defaultMessage: "Processed Events",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "apmsTotalEvents",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 15
    }
  }, (0, _format_number.formatMetric)(props.totalEvents, '0.[0]a')), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.apmPanel.lastEventLabel",
    defaultMessage: "Last Event",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "apmsBytesSent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.apmPanel.lastEventDescription",
    defaultMessage: "{timeOfLastEvent} ago",
    values: {
      timeOfLastEvent: (0, _common.formatTimestampToDuration)(+(0, _moment.default)(props.timeOfLastEvent), _constants.CALCULATE_DURATION_SINCE)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: goToInstances(),
    "aria-label": aria,
    "data-test-subj": "apmListing",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 21
    }
  }, link)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  }, setupModeMetricbeatMigrationTooltip))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.apmPanel.memoryUsageLabel",
    defaultMessage: "Memory Usage (delta)",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "apmMemoryUsage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.BytesUsage, {
    usedBytes: props.memRss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  })))))));
}