"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringTimeseries = MonitoringTimeseries;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _get_color = require("./get_color");
var _timeseries_visualization = require("./timeseries_visualization");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/chart/monitoring_timeseries.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function formatTicksFor(series, formatProperty = 'metric.format') {
  const format = (0, _lodash.get)(series, formatProperty, '0,0.0');
  const units = (0, _lodash.get)(series, 'metric.units', '');
  return function formatTicks(val) {
    let formatted = (0, _numeral.default)(val).format(format);

    // numeral write 'B' as the actual size (e.g., 'MB')
    if (units !== 'B' && units !== '') {
      formatted += ' ' + units;
    }
    return formatted;
  };
}
function MonitoringTimeseries({
  series,
  onBrush
}) {
  const dataset = series.map((s, index) => {
    return {
      color: (0, _get_color.getColor)(s.metric.app, index),
      data: s.data,
      label: s.metric.label
    };
  });
  const firstSeries = (0, _lodash.first)(series);
  const timeRange = (0, _lodash.get)(firstSeries, 'timeRange');
  const formatTicks = formatTicksFor(firstSeries);
  const legendFormatter = firstSeries.metric.legendFormat && formatTicksFor(firstSeries, 'metric.legendFormat');
  return /*#__PURE__*/_react.default.createElement(_timeseries_visualization.TimeseriesVisualization, {
    series: dataset,
    timeRange: timeRange,
    tickFormatter: formatTicks,
    legendFormatter: legendFormatter,
    onBrush: onBrush,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
}