"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatMonitoringError = formatMonitoringError;
exports.useRequestErrorHandler = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _format_msg = require("../../lib/format_msg");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/hooks/use_request_error_handler.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function formatMonitoringError(err) {
  var _err$response, _err$response2;
  if ((_err$response = err.response) !== null && _err$response !== void 0 && _err$response.status && ((_err$response2 = err.response) === null || _err$response2 === void 0 ? void 0 : _err$response2.status) !== -1) {
    var _err$body, _err$response3;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    }, (_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.message), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.ajaxErrorHandler.httpErrorMessage",
      defaultMessage: "HTTP {errStatus}",
      values: {
        errStatus: (_err$response3 = err.response) === null || _err$response3 === void 0 ? void 0 : _err$response3.status
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 11
      }
    })));
  }
  return (0, _format_msg.formatMsg)(err);
}
const useRequestErrorHandler = () => {
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useCallback)(err => {
    var _err$response4, _err$response5;
    if (((_err$response4 = err.response) === null || _err$response4 === void 0 ? void 0 : _err$response4.status) === 403) {
      // redirect to error message view
      history.push('/access-denied');
    } else if (((_err$response5 = err.response) === null || _err$response5 === void 0 ? void 0 : _err$response5.status) === 404 && !(0, _lodash.includes)(window.location.hash, 'no-data')) {
      var _services$notificatio;
      // pass through if this is a 404, and we're already on the no-data page
      const formattedError = formatMonitoringError(err);
      (_services$notificatio = services.notifications) === null || _services$notificatio === void 0 ? void 0 : _services$notificatio.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.monitoring.ajaxErrorHandler.requestFailedNotificationTitle', {
          defaultMessage: 'Monitoring Request Failed'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 13
          }
        }, formattedError, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 60,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          color: "danger",
          onClick: () => window.location.reload(),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.monitoring.ajaxErrorHandler.requestFailedNotification.retryButtonLabel",
          defaultMessage: "Retry",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 17
          }
        }))), services)
      });
    } else {
      var _services$notificatio2;
      (_services$notificatio2 = services.notifications) === null || _services$notificatio2 === void 0 ? void 0 : _services$notificatio2.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.monitoring.ajaxErrorHandler.requestErrorNotificationTitle', {
          defaultMessage: 'Monitoring Request Error'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(formatMonitoringError(err), services)
      });
    }
  }, [history, services]);
};
exports.useRequestErrorHandler = useRequestErrorHandler;