"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSingleMetricViewerEmbeddableFactory = void 0;
var _i18n = require("@kbn/i18n");
var _presentationUtil = require("@kbn/presentation-util");
var _react = _interopRequireDefault(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _presentationContainers = require("@kbn/presentation-containers");
var _ = require("..");
var _single_metric_viewer_controls_initializer = require("./single_metric_viewer_controls_initializer");
var _single_metric_viewer_data_fetcher = require("./single_metric_viewer_data_fetcher");
var _get_services = require("./get_services");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _single_metric_viewer = require("../../shared_components/single_metric_viewer");
var _single_metric_viewer_setup_flyout = require("./single_metric_viewer_setup_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/single_metric_viewer/single_metric_viewer_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getSingleMetricViewerEmbeddableFactory = getStartServices => {
  const factory = {
    type: _.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      const services = await (0, _get_services.getServices)(getStartServices);
      const subscriptions = new _rxjs.Subscription();
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState.rawState);
      const singleMetricManager = (0, _single_metric_viewer_controls_initializer.initializeSingleMetricViewerControls)(initialState.rawState, titleManager.api);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...timeRangeManager.getLatestState(),
            ...singleMetricManager.getLatestState()
          },
          references: []
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, timeRangeManager.anyStateChange$, singleMetricManager.anyStateChange$),
        getComparators: () => {
          return {
            ..._presentationPublishing.titleComparators,
            ..._presentationPublishing.timeRangeComparators,
            ..._single_metric_viewer_controls_initializer.singleMetricViewerComparators,
            id: 'skip',
            query: 'skip',
            filters: 'skip',
            refreshConfig: 'skip'
          };
        },
        onReset: lastSaved => {
          timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          if (lastSaved) singleMetricManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        }
      });
      const api = finalizeApi({
        isEditingEnabled: () => true,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.ml.singleMetricViewerEmbeddable.typeDisplayName', {
          defaultMessage: 'single metric viewer'
        }),
        onEdit: async () => {
          const [coreStart, {
            data,
            share
          }, {
            mlApi
          }] = services;
          (0, _presentationUtil.openLazyFlyout)({
            core: coreStart,
            parentApi,
            flyoutProps: {
              focusedPanelId: uuid
            },
            loadContent: async ({
              closeFlyout
            }) => {
              return /*#__PURE__*/_react.default.createElement(_single_metric_viewer_setup_flyout.EmbeddableSingleMetricViewerUserInput, {
                coreStart: coreStart,
                services: {
                  data,
                  share
                },
                mlApi: mlApi,
                onConfirm: result => {
                  singleMetricManager.api.updateUserInput(result);
                  closeFlyout();
                },
                onCancel: closeFlyout,
                input: {
                  ...titleManager.getLatestState(),
                  ...singleMetricManager.getLatestState()
                },
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 114,
                  columnNumber: 17
                }
              });
            }
          });
        },
        ...titleManager.api,
        ...timeRangeManager.api,
        ...singleMetricManager.api,
        ...unsavedChangesApi,
        dataLoading$,
        blockingError$,
        serializeState
      });
      const {
        singleMetricViewerData$,
        onDestroy
      } = (0, _single_metric_viewer_data_fetcher.initializeSingleMetricViewerDataFetcher)(api, services[1].data.query.timefilter.timefilter);
      const SingleMetricViewerComponent = (0, _single_metric_viewer.getSingleMetricViewerComponent)(...services, api);
      return {
        api,
        Component: () => {
          var _singleMetricViewerDa;
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          const {
            singleMetricViewerData,
            bounds,
            lastRefresh
          } = (0, _presentationPublishing.useStateFromPublishingSubject)(singleMetricViewerData$);
          (0, _use_embeddable_execution_context.useReactEmbeddableExecutionContext)(services[0].executionContext, parentApi.executionContext, _.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE, uuid);
          (0, _useUnmount.default)(() => {
            singleMetricManager.cleanup();
            onDestroy();
            subscriptions.unsubscribe();
          });

          // Need to make sure we fall back to `undefined` if `functionDescription` is an empty string,
          // otherwise anomaly table data will not be loaded.
          const functionDescription = ((_singleMetricViewerDa = singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.functionDescription) !== null && _singleMetricViewerDa !== void 0 ? _singleMetricViewerDa : '') === '' ? undefined : singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.functionDescription;
          return /*#__PURE__*/_react.default.createElement(SingleMetricViewerComponent, {
            shouldShowForecastButton: true,
            bounds: bounds,
            functionDescription: functionDescription,
            lastRefresh: lastRefresh,
            onError: error => blockingError$.next(error),
            selectedDetectorIndex: singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.selectedDetectorIndex,
            selectedEntities: singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.selectedEntities,
            selectedJobId: singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.jobIds[0],
            forecastId: singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.forecastId,
            uuid: api.uuid,
            onForecastIdChange: api.updateForecastId,
            onRenderComplete: () => {
              dataLoading$.next(false);
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 179,
              columnNumber: 13
            }
          });
        }
      };
    }
  };
  return factory;
};
exports.getSingleMetricViewerEmbeddableFactory = getSingleMetricViewerEmbeddableFactory;