"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSeriesExplorerEmbeddableChart = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _rxjs = require("rxjs");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _eui = require("@elastic/eui");
var _search = require("../../../../common/constants/search");
var _job_utils = require("../../../../common/util/job_utils");
var _loading_indicator = require("../../components/loading_indicator/loading_indicator");
var _forecasting_modal = require("../components/forecasting_modal/forecasting_modal");
var _timeseriesexplorer_no_chart_data = require("../components/timeseriesexplorer_no_chart_data");
var _timeseriesexplorer_constants = require("../timeseriesexplorer_constants");
var _get_controls_for_detector = require("../get_controls_for_detector");
var _timeseries_chart_with_tooltip = require("../components/timeseries_chart/timeseries_chart_with_tooltip");
var _get_function_description = require("../get_function_description");
var _timeseriesexplorer_chart_data_error = require("../components/timeseriesexplorer_chart_data_error");
var _timeseriesexplorer_checkbox = require("./timeseriesexplorer_checkbox");
var _time_buckets_service = require("../../util/time_buckets_service");
var _time_series_explorer_service = require("../../util/time_series_explorer_service");
var _timeseriesexplorer_utils = require("../timeseriesexplorer_utils");
var _job_service = require("../../services/job_service");
var _forecast_service = require("../../services/forecast_service");
var _timeseriesexplorer_title = require("./timeseriesexplorer_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/timeseriesexplorer_embeddable_chart/timeseriesexplorer_embeddable_chart.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering Single Metric Viewer.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TimeSeriesExplorerEmbeddableChart extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", (0, _timeseriesexplorer_utils.getTimeseriesexplorerDefaultState)());
    (0, _defineProperty2.default)(this, "subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "unmounted", false);
    /**
     * Subject for listening brush time range selection.
     */
    (0, _defineProperty2.default)(this, "contextChart$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "getBoundsRoundedToInterval", void 0);
    (0, _defineProperty2.default)(this, "mlTimeSeriesExplorer", void 0);
    (0, _defineProperty2.default)(this, "mlForecastService", void 0);
    /**
     * Returns field names that don't have a selection yet.
     */
    (0, _defineProperty2.default)(this, "getFieldNamesWithEmptyValues", () => {
      const latestEntityControls = this.getControlsForDetector();
      return latestEntityControls.filter(({
        fieldValue
      }) => fieldValue === null).map(({
        fieldName
      }) => fieldName);
    });
    /**
     * Checks if all entity control dropdowns have a selection.
     */
    (0, _defineProperty2.default)(this, "arePartitioningFieldsProvided", () => {
      const fieldNamesWithEmptyValues = this.getFieldNamesWithEmptyValues();
      return fieldNamesWithEmptyValues.length === 0;
    });
    (0, _defineProperty2.default)(this, "toggleShowAnnotationsHandler", () => {
      this.setState(prevState => ({
        showAnnotations: !prevState.showAnnotations
      }));
    });
    (0, _defineProperty2.default)(this, "toggleShowForecastHandler", () => {
      this.setState(prevState => ({
        showForecast: !prevState.showForecast
      }));
    });
    (0, _defineProperty2.default)(this, "toggleShowModelBoundsHandler", () => {
      this.setState({
        showModelBounds: !this.state.showModelBounds
      });
    });
    (0, _defineProperty2.default)(this, "setFunctionDescription", selectedFuction => {
      this.props.appStateHandler(_timeseriesexplorer_constants.APP_STATE_ACTION.SET_FUNCTION_DESCRIPTION, selectedFuction);
    });
    (0, _defineProperty2.default)(this, "previousChartProps", {});
    (0, _defineProperty2.default)(this, "previousShowAnnotations", undefined);
    (0, _defineProperty2.default)(this, "previousShowForecast", undefined);
    (0, _defineProperty2.default)(this, "previousShowModelBounds", undefined);
    (0, _defineProperty2.default)(this, "tableFilter", (field, value, operator) => {
      const entities = this.getControlsForDetector();
      const entity = entities.find(({
        fieldName
      }) => fieldName === field);
      if (entity === undefined) {
        return;
      }
      const {
        appStateHandler
      } = this.props;
      let resultValue = '';
      if (operator === '+' && entity.fieldValue !== value) {
        resultValue = value;
      } else if (operator === '-' && entity.fieldValue === value) {
        resultValue = null;
      } else {
        return;
      }
      const resultEntities = {
        ...entities.reduce((appStateEntities, appStateEntity) => {
          appStateEntities[appStateEntity.fieldName] = appStateEntity.fieldValue;
          return appStateEntities;
        }, {}),
        [entity.fieldName]: resultValue
      };
      appStateHandler(_timeseriesexplorer_constants.APP_STATE_ACTION.SET_ENTITIES, resultEntities);
    });
    (0, _defineProperty2.default)(this, "contextChartSelectedInitCallDone", false);
    (0, _defineProperty2.default)(this, "contextChartSelected", selection => {
      const zoomState = {
        from: selection.from.toISOString(),
        to: selection.to.toISOString()
      };
      if ((0, _lodash.isEqual)(this.props.zoom, zoomState) && this.state.focusChartData !== undefined && this.props.previousRefresh === this.props.lastRefresh) {
        return;
      }
      this.contextChart$.next(selection);
      this.props.appStateHandler(_timeseriesexplorer_constants.APP_STATE_ACTION.SET_ZOOM, zoomState);
    });
    (0, _defineProperty2.default)(this, "loadAnomaliesTableData", (earliestMs, latestMs) => {
      const {
        dateFormatTz,
        selectedDetectorIndex,
        selectedJob,
        tableInterval,
        tableSeverity,
        functionDescription
      } = this.props;
      const entityControls = this.getControlsForDetector();
      return this.context.services.mlServices.mlApi.results.getAnomaliesTableData([selectedJob.job_id], this.getCriteriaFields(selectedDetectorIndex, entityControls), [], tableInterval, tableSeverity, earliestMs, latestMs, dateFormatTz, _search.ANOMALIES_TABLE_DEFAULT_QUERY_SIZE, undefined, undefined, functionDescription).pipe((0, _rxjs.map)(resp => {
        const anomalies = resp.anomalies;
        anomalies.forEach(anomaly => {
          // Add a detector property to each anomaly.
          // Default to functionDescription if no description available.
          // TODO - when job_service is moved server_side, move this to server endpoint.
          const jobDetectors = selectedJob.analysis_config.detectors;
          const detector = jobDetectors[anomaly.detectorIndex];
          anomaly.detector = (0, _lodash.get)(detector, ['detector_description'], anomaly.source.function_description);

          // For detectors with rules, add a property with the rule count.
          const customRules = detector.custom_rules;
          if (customRules !== undefined) {
            anomaly.rulesLength = customRules.length;
          }

          // Add properties used for building the links menu.
          // TODO - when job_service is moved server_side, move this to server endpoint.
          if (selectedJob.custom_settings && selectedJob.custom_settings.custom_urls) {
            anomaly.customUrls = selectedJob.custom_settings.custom_urls;
          }
        });
        return {
          tableData: {
            anomalies,
            interval: resp.interval,
            examplesByJobId: resp.examplesByJobId,
            showViewSeriesLink: false
          }
        };
      }));
    });
    (0, _defineProperty2.default)(this, "setForecastId", forecastId => {
      this.props.appStateHandler(_timeseriesexplorer_constants.APP_STATE_ACTION.SET_FORECAST_ID, forecastId);
    });
    (0, _defineProperty2.default)(this, "displayErrorToastMessages", (error, errorMsg) => {
      if (this.props.toastNotificationService) {
        this.props.toastNotificationService.displayErrorToast(error, errorMsg, 2000);
      }
      this.setState({
        loading: false,
        chartDataError: errorMsg
      });
    });
    (0, _defineProperty2.default)(this, "loadSingleMetricData", (fullRefresh = true) => {
      const {
        autoZoomDuration,
        bounds,
        selectedDetectorIndex,
        selectedForecastId,
        zoom,
        functionDescription,
        selectedJob
      } = this.props;
      const {
        loadCounter: currentLoadCounter
      } = this.state;
      if (selectedJob === undefined) {
        return;
      }
      if ((0, _get_function_description.isMetricDetector)(selectedJob, selectedDetectorIndex) && functionDescription === undefined) {
        return;
      }
      const functionToPlotByIfMetric = _mlAnomalyUtils.aggregationTypeTransform.toES(functionDescription);
      this.contextChartSelectedInitCallDone = false;

      // Only when `fullRefresh` is true we'll reset all data
      // and show the loading spinner within the page.
      const entityControls = this.getControlsForDetector();
      this.setState({
        fullRefresh,
        loadCounter: currentLoadCounter + 1,
        loading: true,
        chartDataError: undefined,
        ...(fullRefresh ? {
          chartDetails: undefined,
          contextChartData: undefined,
          contextForecastData: undefined,
          focusChartData: undefined,
          focusForecastData: undefined,
          modelPlotEnabled: (0, _job_utils.isModelPlotChartableForDetector)(selectedJob, selectedDetectorIndex) && (0, _job_utils.isModelPlotEnabled)(selectedJob, selectedDetectorIndex, entityControls),
          hasResults: false,
          dataNotChartable: false
        } : {})
      }, () => {
        const {
          loadCounter,
          modelPlotEnabled
        } = this.state;
        const {
          selectedJob
        } = this.props;
        const detectorIndex = selectedDetectorIndex;
        let awaitingCount = 3;
        const stateUpdate = {};

        // finish() function, called after each data set has been loaded and processed.
        // The last one to call it will trigger the page render.
        const finish = counterVar => {
          awaitingCount--;
          if (awaitingCount === 0 && counterVar === loadCounter) {
            stateUpdate.hasResults = Array.isArray(stateUpdate.contextChartData) && stateUpdate.contextChartData.length > 0 || Array.isArray(stateUpdate.contextForecastData) && stateUpdate.contextForecastData.length > 0;
            stateUpdate.loading = false;

            // Set zoomFrom/zoomTo attributes in scope which will result in the metric chart automatically
            // selecting the specified range in the context chart, and so loading that date range in the focus chart.
            // Only touch the zoom range if data for the context chart has been loaded and all necessary
            // partition fields have a selection.
            if (stateUpdate.contextChartData.length && this.arePartitioningFieldsProvided() === true) {
              // Check for a zoom parameter in the appState (URL).
              let focusRange = this.mlTimeSeriesExplorer.calculateInitialFocusRange(zoom, stateUpdate.contextAggregationInterval, bounds);
              if (focusRange === undefined || this.previousSelectedForecastId !== this.props.selectedForecastId) {
                focusRange = this.mlTimeSeriesExplorer.calculateDefaultFocusRange(autoZoomDuration, stateUpdate.contextAggregationInterval, stateUpdate.contextChartData, stateUpdate.contextForecastData);
                this.previousSelectedForecastId = this.props.selectedForecastId;
              }
              this.contextChartSelected({
                from: focusRange[0],
                to: focusRange[1]
              });
            }
            this.setState(stateUpdate);
            if (this.props.onRenderComplete !== undefined) {
              this.props.onRenderComplete();
            }
          }
        };
        const nonBlankEntities = entityControls.filter(entity => {
          return entity.fieldValue !== null;
        });
        if (modelPlotEnabled === false && (0, _job_utils.isSourceDataChartableForDetector)(selectedJob, detectorIndex) === false && nonBlankEntities.length > 0) {
          // For detectors where model plot has been enabled with a terms filter and the
          // selected entity(s) are not in the terms list, indicate that data cannot be viewed.
          stateUpdate.hasResults = false;
          stateUpdate.loading = false;
          stateUpdate.dataNotChartable = true;
          this.setState(stateUpdate);
          return;
        }

        // Calculate the aggregation interval for the context chart.
        // Context chart swimlane will display bucket anomaly score at the same interval.
        stateUpdate.contextAggregationInterval = this.mlTimeSeriesExplorer.calculateAggregationInterval(bounds, _timeseriesexplorer_constants.CHARTS_POINT_TARGET, selectedJob);

        // Ensure the search bounds align to the bucketing interval so that the first and last buckets are complete.
        // For sum or count detectors, short buckets would hold smaller values, and model bounds would also be affected
        // to some extent with all detector functions if not searching complete buckets.
        const searchBounds = this.getBoundsRoundedToInterval(bounds, stateUpdate.contextAggregationInterval, false);

        // Query 1 - load metric data at low granularity across full time range.
        // Pass a counter flag into the finish() function to make sure we only process the results
        // for the most recent call to the load the data in cases where the job selection and time filter
        // have been altered in quick succession (such as from the job picker with 'Apply time range').
        const counter = loadCounter;
        this.context.services.mlServices.mlTimeSeriesSearchService.getMetricData(selectedJob, detectorIndex, nonBlankEntities, searchBounds.min.valueOf(), searchBounds.max.valueOf(), stateUpdate.contextAggregationInterval.asMilliseconds(), functionToPlotByIfMetric).toPromise().then(resp => {
          const fullRangeChartData = this.mlTimeSeriesExplorer.processMetricPlotResults(resp.results, modelPlotEnabled);
          stateUpdate.contextChartData = fullRangeChartData;
          finish(counter);
        }).catch(err => {
          const errorMsg = _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.metricDataErrorMessage', {
            defaultMessage: 'Error getting metric data'
          });
          this.displayErrorToastMessages(err, errorMsg);
        });

        // Query 2 - load max record score at same granularity as context chart
        // across full time range for use in the swimlane.
        this.context.services.mlServices.mlResultsService.getRecordMaxScoreByTime(selectedJob.job_id, this.getCriteriaFields(detectorIndex, entityControls), searchBounds.min.valueOf(), searchBounds.max.valueOf(), stateUpdate.contextAggregationInterval.asMilliseconds(), functionToPlotByIfMetric).then(resp => {
          const fullRangeRecordScoreData = this.mlTimeSeriesExplorer.processRecordScoreResults(resp.results);
          stateUpdate.swimlaneData = fullRangeRecordScoreData;
          finish(counter);
        }).catch(err => {
          const errorMsg = _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.bucketAnomalyScoresErrorMessage', {
            defaultMessage: 'Error getting bucket anomaly scores'
          });
          this.displayErrorToastMessages(err, errorMsg);
        });

        // Query 3 - load details on the chart used in the chart title (charting function and entity(s)).
        this.context.services.mlServices.mlTimeSeriesSearchService.getChartDetails(selectedJob, detectorIndex, entityControls, searchBounds.min.valueOf(), searchBounds.max.valueOf()).then(resp => {
          stateUpdate.chartDetails = resp.results;
          finish(counter);
        }).catch(err => {
          this.displayErrorToastMessages(err, _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.entityCountsErrorMessage', {
            defaultMessage: 'Error getting entity counts'
          }));
        });

        // Plus query for forecast data if there is a forecastId stored in the appState.
        if (selectedForecastId !== undefined) {
          awaitingCount++;
          const detector = selectedJob.analysis_config.detectors[detectorIndex];
          const esAgg = (0, _job_utils.mlFunctionToESAggregation)(detector.function);
          const aggType = modelPlotEnabled === false && (esAgg === _mlAnomalyUtils.ML_JOB_AGGREGATION.SUM || esAgg === _mlAnomalyUtils.ML_JOB_AGGREGATION.COUNT) ? {
            avg: 'sum',
            max: 'sum',
            min: 'sum'
          } : undefined;
          this.mlForecastService.getForecastData(selectedJob, detectorIndex, selectedForecastId, nonBlankEntities, searchBounds.min.valueOf(), searchBounds.max.valueOf(), stateUpdate.contextAggregationInterval.asMilliseconds(), aggType).toPromise().then(resp => {
            stateUpdate.contextForecastData = this.mlTimeSeriesExplorer.processForecastResults(resp.results);
            finish(counter);
          }).catch(err => {
            this.displayErrorToastMessages(err, _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastDataErrorMessage', {
              defaultMessage: 'Error loading forecast data for forecast ID {forecastId}',
              values: {
                forecastId: selectedForecastId
              }
            }));
          });
        }
      });
    });
    /**
     * Updates local state of detector related controls from the global state.
     * @param callback to invoke after a state update.
     */
    (0, _defineProperty2.default)(this, "getControlsForDetector", () => {
      const {
        selectedDetectorIndex,
        selectedEntities,
        selectedJob
      } = this.props;
      return (0, _get_controls_for_detector.getControlsForDetector)(selectedDetectorIndex, selectedEntities, selectedJob);
    });
  }
  getFocusAggregationInterval(selection) {
    const {
      selectedJob
    } = this.props;

    // Calculate the aggregation interval for the focus chart.
    const bounds = {
      min: (0, _momentTimezone.default)(selection.from),
      max: (0, _momentTimezone.default)(selection.to)
    };
    return this.mlTimeSeriesExplorer.calculateAggregationInterval(bounds, _timeseriesexplorer_constants.CHARTS_POINT_TARGET, selectedJob);
  }

  /**
   * Gets focus data for the current component state
   */
  getFocusData(selection) {
    const {
      selectedForecastId,
      selectedDetectorIndex,
      functionDescription,
      selectedJob
    } = this.props;
    const {
      modelPlotEnabled
    } = this.state;
    if ((0, _get_function_description.isMetricDetector)(selectedJob, selectedDetectorIndex) && functionDescription === undefined) {
      return;
    }
    const entityControls = this.getControlsForDetector();

    // Calculate the aggregation interval for the focus chart.
    const bounds = {
      min: (0, _momentTimezone.default)(selection.from),
      max: (0, _momentTimezone.default)(selection.to)
    };
    const focusAggregationInterval = this.getFocusAggregationInterval(selection);

    // Ensure the search bounds align to the bucketing interval so that the first and last buckets are complete.
    // For sum or count detectors, short buckets would hold smaller values, and model bounds would also be affected
    // to some extent with all detector functions if not searching complete buckets.
    const searchBounds = this.getBoundsRoundedToInterval(bounds, focusAggregationInterval, false);
    return this.mlTimeSeriesExplorer.getFocusData(this.getCriteriaFields(selectedDetectorIndex, entityControls), selectedDetectorIndex, focusAggregationInterval, selectedForecastId, modelPlotEnabled, entityControls.filter(entity => entity.fieldValue !== null), searchBounds, selectedJob, functionDescription, _timeseriesexplorer_constants.TIME_FIELD_NAME);
  }
  /**
   * Updates criteria fields for API calls, e.g. getAnomaliesTableData
   * @param detectorIndex
   * @param entities
   */
  getCriteriaFields(detectorIndex, entities) {
    // Only filter on the entity if the field has a value.
    const nonBlankEntities = entities.filter(entity => entity.fieldValue !== null);
    return [{
      fieldName: 'detector_index',
      fieldValue: detectorIndex
    }, ...nonBlankEntities];
  }
  async componentDidMount() {
    this.getBoundsRoundedToInterval = (0, _time_buckets_service.timeBucketsServiceFactory)(this.context.services.uiSettings).getBoundsRoundedToInterval;
    this.mlTimeSeriesExplorer = (0, _time_series_explorer_service.timeSeriesExplorerServiceFactory)(this.context.services.uiSettings, this.context.services.mlServices.mlApi, this.context.services.mlServices.mlResultsService);
    this.mlForecastService = (0, _forecast_service.forecastServiceFactory)(this.context.services.mlServices.mlApi);

    // Listen for context chart updates.
    this.subscriptions.add(this.contextChart$.pipe((0, _rxjs.tap)(selection => {
      this.setState({
        zoomFrom: selection.from,
        zoomTo: selection.to
      });
    }), (0, _rxjs.debounceTime)(500), (0, _rxjs.tap)(selection => {
      const {
        contextChartData,
        contextForecastData,
        focusChartData,
        zoomFromFocusLoaded,
        zoomToFocusLoaded
      } = this.state;
      if ((contextChartData === undefined || contextChartData.length === 0) && (contextForecastData === undefined || contextForecastData.length === 0)) {
        return;
      }
      if (this.contextChartSelectedInitCallDone === false && focusChartData === undefined || zoomFromFocusLoaded.getTime() !== selection.from.getTime() || zoomToFocusLoaded.getTime() !== selection.to.getTime()) {
        this.contextChartSelectedInitCallDone = true;
        this.setState({
          loading: true,
          fullRefresh: false
        });
      }
    }), (0, _rxjs.switchMap)(selection => {
      // Calculate the aggregation interval for the focus chart.
      const bounds = {
        min: (0, _momentTimezone.default)(selection.from),
        max: (0, _momentTimezone.default)(selection.to)
      };

      // Ensure the search bounds align to the bucketing interval so that the first and last buckets are complete.
      // For sum or count detectors, short buckets would hold smaller values, and model bounds would also be affected
      // to some extent with all detector functions if not searching complete buckets.
      const searchBounds = this.getBoundsRoundedToInterval(bounds, this.getFocusAggregationInterval({
        from: selection.from,
        to: selection.to
      }), false);
      return (0, _rxjs.forkJoin)([this.getFocusData(selection),
      // Load the data for the anomalies table.
      this.loadAnomaliesTableData(searchBounds.min.valueOf(), searchBounds.max.valueOf())]);
    }), (0, _rxjs.withLatestFrom)(this.contextChart$)).subscribe(([[refreshFocusData, tableData], selection]) => {
      const {
        modelPlotEnabled
      } = this.state;

      // All the data is ready now for a state update.
      this.setState({
        focusAggregationInterval: this.getFocusAggregationInterval({
          from: selection.from,
          to: selection.to
        }),
        loading: false,
        showModelBoundsCheckbox: modelPlotEnabled && refreshFocusData.focusChartData.length > 0,
        zoomFromFocusLoaded: selection.from,
        zoomToFocusLoaded: selection.to,
        ...refreshFocusData,
        ...tableData
      });
    }));
    if (this.context && this.props.selectedJob !== undefined) {
      // Populate the map of jobs / detectors / field formatters for the selected IDs and refresh.
      this.context.services.mlServices.mlFieldFormatService.populateFormats([this.props.selectedJob.job_id]);
    }

    // Populate mlJobService to work with LinksMenuUI.
    this.mlJobService = (0, _job_service.mlJobServiceFactory)(undefined, this.context.services.mlServices.mlApi);
    await this.mlJobService.loadJobsWrapper();
    this.componentDidUpdate();
  }
  componentDidUpdate(previousProps) {
    var _previousProps$select, _this$props$selectedJ;
    if (previousProps === undefined || previousProps.selectedForecastId !== this.props.selectedForecastId) {
      if (this.props.selectedForecastId !== undefined) {
        // Ensure the forecast data will be shown if hidden previously.
        this.setState({
          showForecast: true
        });
        // Not best practice but we need the previous value for another comparison
        // once all the data was loaded.
        if (previousProps !== undefined) {
          this.previousSelectedForecastId = previousProps.selectedForecastId;
        }
      }
    }
    if (previousProps === undefined || !(0, _lodash.isEqual)(previousProps.bounds, this.props.bounds) || !(0, _lodash.isEqual)(previousProps.lastRefresh, this.props.lastRefresh) && previousProps.lastRefresh !== 0 || !(0, _lodash.isEqual)(previousProps.selectedDetectorIndex, this.props.selectedDetectorIndex) || !(0, _lodash.isEqual)(previousProps.selectedEntities, this.props.selectedEntities) || previousProps.selectedForecastId !== this.props.selectedForecastId || ((_previousProps$select = previousProps.selectedJob) === null || _previousProps$select === void 0 ? void 0 : _previousProps$select.job_id) !== ((_this$props$selectedJ = this.props.selectedJob) === null || _this$props$selectedJ === void 0 ? void 0 : _this$props$selectedJ.job_id) || previousProps.selectedJobId !== this.props.selectedJobId || previousProps.functionDescription !== this.props.functionDescription) {
      var _previousProps$select2, _this$props$selectedJ2;
      const fullRefresh = previousProps === undefined || !(0, _lodash.isEqual)(previousProps.bounds, this.props.bounds) || !(0, _lodash.isEqual)(previousProps.selectedDetectorIndex, this.props.selectedDetectorIndex) || !(0, _lodash.isEqual)(previousProps.selectedEntities, this.props.selectedEntities) || previousProps.selectedForecastId !== this.props.selectedForecastId || previousProps.selectedJobId !== this.props.selectedJobId || ((_previousProps$select2 = previousProps.selectedJob) === null || _previousProps$select2 === void 0 ? void 0 : _previousProps$select2.job_id) !== ((_this$props$selectedJ2 = this.props.selectedJob) === null || _this$props$selectedJ2 === void 0 ? void 0 : _this$props$selectedJ2.job_id) || previousProps.functionDescription !== this.props.functionDescription;
      this.loadSingleMetricData(fullRefresh);
    }
    if (previousProps === undefined) {
      return;
    }
  }
  componentWillUnmount() {
    this.subscriptions.unsubscribe();
    this.unmounted = true;
  }
  render() {
    const {
      autoZoomDuration,
      bounds,
      chartWidth,
      chartHeight,
      lastRefresh,
      onForecastComplete,
      selectedEntities,
      selectedDetectorIndex,
      selectedJob,
      selectedJobStats,
      shouldShowForecastButton
    } = this.props;
    const {
      chartDetails,
      contextAggregationInterval,
      contextChartData,
      contextForecastData,
      dataNotChartable,
      focusAggregationInterval,
      focusAnnotationData,
      focusChartData,
      focusForecastData,
      fullRefresh,
      hasResults,
      loading,
      modelPlotEnabled,
      showAnnotations,
      showAnnotationsCheckbox,
      showForecast,
      showForecastCheckbox,
      showModelBounds,
      showModelBoundsCheckbox,
      swimlaneData,
      tableData,
      zoomFrom,
      zoomTo,
      zoomFromFocusLoaded,
      zoomToFocusLoaded,
      chartDataError,
      sourceIndicesWithGeoFields
    } = this.state;
    const chartProps = {
      modelPlotEnabled,
      contextChartData,
      contextChartSelected: this.contextChartSelected,
      contextForecastData,
      contextAggregationInterval,
      swimlaneData,
      focusAnnotationData,
      focusChartData,
      focusForecastData,
      focusAggregationInterval,
      svgWidth: chartWidth,
      svgHeight: chartHeight,
      zoomFrom,
      zoomTo,
      zoomFromFocusLoaded,
      zoomToFocusLoaded,
      autoZoomDuration
    };
    const entityControls = this.getControlsForDetector();
    const fieldNamesWithEmptyValues = this.getFieldNamesWithEmptyValues();
    const arePartitioningFieldsProvided = this.arePartitioningFieldsProvided();
    let renderFocusChartOnly = true;
    if ((0, _lodash.isEqual)(this.previousChartProps.focusForecastData, chartProps.focusForecastData) && (0, _lodash.isEqual)(this.previousChartProps.focusChartData, chartProps.focusChartData) && (0, _lodash.isEqual)(this.previousChartProps.focusAnnotationData, chartProps.focusAnnotationData) && this.previousShowForecast === showForecast && this.previousShowModelBounds === showModelBounds && this.props.previousRefresh === lastRefresh) {
      renderFocusChartOnly = false;
    }
    this.previousChartProps = chartProps;
    this.previousShowForecast = showForecast;
    this.previousShowModelBounds = showModelBounds;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fieldNamesWithEmptyValues.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.timeSeriesExplorer.singleMetricRequiredMessage",
        defaultMessage: "To view a single metric, select {missingValuesCount, plural, one {a value for {fieldName1}} other {values for {fieldName1} and {fieldName2}}}.",
        values: {
          missingValuesCount: fieldNamesWithEmptyValues.length,
          fieldName1: fieldNamesWithEmptyValues[0],
          fieldName2: fieldNamesWithEmptyValues[1]
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 875,
          columnNumber: 17
        }
      }),
      iconType: "question",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 873,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 888,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 891,
        columnNumber: 9
      }
    }), fullRefresh && loading === true && /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
      label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.loadingLabel', {
        defaultMessage: 'Loading'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 894,
        columnNumber: 11
      }
    }), loading === false && chartDataError !== undefined && /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_chart_data_error.TimeseriesexplorerChartDataError, {
      errorMsg: chartDataError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 902,
        columnNumber: 11
      }
    }), arePartitioningFieldsProvided && selectedJob && (fullRefresh === false || loading === false) && hasResults === false && chartDataError === undefined && /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_no_chart_data.TimeseriesexplorerNoChartData, {
      dataNotChartable: dataNotChartable,
      entities: entityControls,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 910,
        columnNumber: 13
      }
    }), arePartitioningFieldsProvided && selectedJob && (fullRefresh === false || loading === false) && hasResults === true && /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 919,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_title.SingleMetricViewerTitle, {
      api: this.props.api,
      functionLabel: chartDetails.functionLabel,
      entityData: chartDetails.entityData,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 920,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        float: 'right'
      },
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 925,
        columnNumber: 15
      }
    }, showModelBoundsCheckbox && /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_checkbox.TimeseriesExplorerCheckbox, {
      id: "toggleModelBoundsCheckbox",
      label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.showModelBoundsLabel', {
        defaultMessage: 'show model bounds'
      }),
      checked: showModelBounds,
      onChange: this.toggleShowModelBoundsHandler,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 927,
        columnNumber: 19
      }
    }), showAnnotationsCheckbox && /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_checkbox.TimeseriesExplorerCheckbox, {
      id: "toggleAnnotationsCheckbox",
      label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationsLabel', {
        defaultMessage: 'annotations'
      }),
      checked: showAnnotations,
      onChange: this.toggleShowAnnotationsHandler,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 938,
        columnNumber: 19
      }
    }), showForecastCheckbox && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 949,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_checkbox.TimeseriesExplorerCheckbox, {
      id: "toggleShowForecastCheckbox",
      label: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": 'mlForecastCheckbox',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 953,
          columnNumber: 25
        }
      }, _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.showForecastLabel', {
        defaultMessage: 'show forecast'
      })),
      checked: showForecast,
      onChange: this.toggleShowForecastHandler,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 950,
        columnNumber: 21
      }
    })), arePartitioningFieldsProvided && selectedJob && shouldShowForecastButton === true && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        textAlign: 'right'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 968,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_forecasting_modal.ForecastingModal, {
      buttonMode: 'empty',
      job: selectedJob,
      jobState: selectedJobStats.state,
      earliestRecordTimestamp: selectedJobStats.data_counts.earliest_record_timestamp,
      latestRecordTimestamp: selectedJobStats.data_counts.latest_record_timestamp,
      detectorIndex: selectedDetectorIndex,
      entities: entityControls,
      setForecastId: this.setForecastId,
      className: "forecast-controls",
      onForecastComplete: onForecastComplete,
      selectedForecastId: this.props.selectedForecastId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 969,
        columnNumber: 23
      }
    }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_tooltip.TimeSeriesChartWithTooltips, {
      chartProps: chartProps,
      contextAggregationInterval: contextAggregationInterval,
      bounds: bounds,
      detectorIndex: selectedDetectorIndex,
      embeddableMode: true,
      renderFocusChartOnly: renderFocusChartOnly,
      selectedJob: selectedJob,
      selectedEntities: selectedEntities,
      showAnnotations: showAnnotations,
      showForecast: showForecast,
      showModelBounds: showModelBounds,
      lastRefresh: lastRefresh,
      tableData: tableData,
      sourceIndicesWithGeoFields: sourceIndicesWithGeoFields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 988,
        columnNumber: 15
      }
    })));
  }
}
exports.TimeSeriesExplorerEmbeddableChart = TimeSeriesExplorerEmbeddableChart;
(0, _defineProperty2.default)(TimeSeriesExplorerEmbeddableChart, "propTypes", {
  api: _propTypes.default.object,
  appStateHandler: _propTypes.default.func.isRequired,
  autoZoomDuration: _propTypes.default.number.isRequired,
  bounds: _propTypes.default.object.isRequired,
  chartWidth: _propTypes.default.number.isRequired,
  chartHeight: _propTypes.default.number,
  lastRefresh: _propTypes.default.number.isRequired,
  onRenderComplete: _propTypes.default.func,
  previousRefresh: _propTypes.default.number.isRequired,
  selectedJob: _propTypes.default.object.isRequired,
  selectedJobStats: _propTypes.default.object.isRequired,
  selectedJobId: _propTypes.default.string.isRequired,
  selectedDetectorIndex: _propTypes.default.number,
  selectedEntities: _propTypes.default.object,
  selectedForecastId: _propTypes.default.string,
  tableInterval: _propTypes.default.string,
  tableSeverity: _propTypes.default.number,
  zoom: _propTypes.default.object,
  toastNotificationService: _propTypes.default.object,
  dataViewsService: _propTypes.default.object,
  onForecastComplete: _propTypes.default.func
});
/**
 * Access ML services in react context.
 */
(0, _defineProperty2.default)(TimeSeriesExplorerEmbeddableChart, "contextType", _public.context);