"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calendarListRouteFactory = exports.calendarDstListRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _check_ml_nodes = require("../../../ml_nodes_check/check_ml_nodes");
var _breadcrumbs = require("../../breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/settings/calendar_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CalendarsList = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../settings/calendars')))).CalendarsList
}));
const calendarListRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.CALENDARS_MANAGE),
  title: _i18n.i18n.translate('xpack.ml.settings.calendarList.docTitle', {
    defaultMessage: 'Calendars'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    isDst: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 28
    }
  })),
  breadcrumbs: [...(0, _breadcrumbs.getADSettingsBreadcrumbs)(navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.anomalyDetection.calendarManagementLabel', {
      defaultMessage: 'Calendar management'
    })
  }]
});
exports.calendarListRouteFactory = calendarListRouteFactory;
const calendarDstListRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.CALENDARS_DST_MANAGE),
  title: _i18n.i18n.translate('xpack.ml.settings.calendarList.docTitle', {
    defaultMessage: 'Calendars'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    isDst: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 28
    }
  })),
  breadcrumbs: [...(0, _breadcrumbs.getADSettingsBreadcrumbs)(navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.anomalyDetection.dstCalendarManagementLabel', {
      defaultMessage: 'DST Calendar management'
    })
  }]
});
exports.calendarDstListRouteFactory = calendarDstListRouteFactory;
const PageWrapper = ({
  isDst
}) => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetCalendars'], {
    getMlNodeCount: _check_ml_nodes.getMlNodeCount
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const [canCreateCalendar, canDeleteCalendar] = (0, _check_capabilities.usePermissionCheck)(['canCreateCalendar', 'canDeleteCalendar']);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CalendarsList, {
    canCreateCalendar,
    canDeleteCalendar,
    isDst,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
};