"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultNodesListState = exports.NodesList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _common = require("@kbn/field-formats-plugin/common");
var _mlUrlState = require("@kbn/ml-url-state");
var _stats_bar = require("../../components/stats_bar");
var _locator = require("../../../../common/constants/locator");
var _trained_models = require("../../services/ml_api_service/trained_models");
var _use_table_settings = require("../../data_frame_analytics/pages/analytics_management/components/analytics_list/use_table_settings");
var _expanded_row = require("./expanded_row");
var _memory_preview_chart = require("./memory_preview_chart");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
var _toast_notification_service = require("../../services/toast_notification_service");
var _use_refresh = require("../../routing/use_refresh");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/memory_usage/nodes_overview/nodes_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDefaultNodesListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: 'name',
  sortDirection: 'asc'
});
exports.getDefaultNodesListState = getDefaultNodesListState;
const NodesList = ({
  compactView = false
}) => {
  var _pageState$queryText;
  const trainedModelsApiService = (0, _trained_models.useTrainedModelsApiService)();
  const refresh = (0, _use_refresh.useRefresh)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const bytesFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const [items, setItems] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const [pageState, updatePageState] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.MEMORY_USAGE, getDefaultNodesListState());
  const searchQueryText = (_pageState$queryText = pageState.queryText) !== null && _pageState$queryText !== void 0 ? _pageState$queryText : '';
  const fetchNodesData = (0, _react.useCallback)(async () => {
    try {
      const nodesResponse = await trainedModelsApiService.getTrainedModelsNodesOverview();
      setItems(nodesResponse.nodes);

      // Update expanded rows.
      nodesResponse.nodes.forEach(node => {
        if (itemIdToExpandedRowMap[node.id]) {
          itemIdToExpandedRowMap[node.id] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
            item: node,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 80,
              columnNumber: 45
            }
          });
        }
      });
      setIsLoading(false);
    } catch (e) {
      displayErrorToast(e, _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.nodesFetchError', {
        defaultMessage: 'Error loading overview on machine learning nodes'
      }));
      setIsLoading(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [itemIdToExpandedRowMap]);
  const toggleDetails = item => {
    const itemIdToExpandedRowMapValues = (0, _lodash.cloneDeep)(itemIdToExpandedRowMap);
    if (itemIdToExpandedRowMapValues[item.id]) {
      delete itemIdToExpandedRowMapValues[item.id];
    } else {
      itemIdToExpandedRowMapValues[item.id] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
        item: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 47
        }
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const columns = [{
    align: 'left',
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: toggleDetails.bind(null, item),
      "aria-label": itemIdToExpandedRowMap[item.id] ? _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.collapseRow', {
        defaultMessage: 'Collapse'
      }) : _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.expandRow', {
        defaultMessage: 'Expand'
      }),
      iconType: itemIdToExpandedRowMap[item.id] ? 'arrowDown' : 'arrowRight',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }),
    'data-test-subj': 'mlNodesTableRowDetailsToggle'
  }, {
    field: 'name',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.nodeNameHeader', {
      defaultMessage: 'Name'
    }),
    width: '200px',
    sortable: true,
    truncateText: true,
    'data-test-subj': 'mlNodesTableColumnName'
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.nodeTotalMemoryHeader', {
      defaultMessage: 'Total memory'
    }),
    width: '200px',
    truncateText: true,
    'data-test-subj': 'mlNodesTableColumnTotalMemory',
    render: v => {
      return bytesFormatter(v.attributes['ml.machine_memory']);
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.nodeMemoryUsageHeader', {
      defaultMessage: 'Memory usage'
    }),
    truncateText: false,
    'data-test-subj': 'mlNodesTableColumnMemoryUsage',
    render: v => {
      return /*#__PURE__*/_react.default.createElement(_memory_preview_chart.MemoryPreviewChart, {
        memoryOverview: v.memory_overview,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 16
        }
      });
    }
  }];
  const nodesStats = (0, _react.useMemo)(() => {
    return {
      total: {
        show: true,
        value: items.length,
        label: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.totalAmountLabel', {
          defaultMessage: 'Total machine learning nodes'
        }),
        'data-test-subj': 'mlTotalNodesCount'
      }
    };
  }, [items]);
  let tableSettings = (0, _use_table_settings.useTableSettings)(items.length, pageState, updatePageState);
  const search = {
    query: searchQueryText,
    onChange: searchChange => {
      if (searchChange.error !== null) {
        return false;
      }
      updatePageState({
        queryText: searchChange.queryText,
        pageIndex: 0
      });
      return true;
    },
    box: {
      incremental: true,
      'data-test-subj': 'mlNodesTableSearchInput'
    }
  };
  (0, _react.useEffect)(function updateOnTimerRefresh() {
    fetchNodesData();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [refresh]);
  if (compactView) {
    tableSettings = {};
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'mlNodesOverviewPanel',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 5
    }
  }, nodesStats && !compactView ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, nodesStats && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: nodesStats,
    dataTestSub: 'mlTrainedModelsNodesStatsBar',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlNodesTableContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({
    allowNeutralSort: false,
    columns: columns,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    items: items,
    itemId: 'id',
    loading: isLoading,
    search: compactView ? undefined : search
  }, tableSettings, {
    rowProps: item => ({
      'data-test-subj': `mlNodesTableRow row-${item.id}`
    }),
    "data-test-subj": isLoading ? 'mlNodesTable loading' : 'mlNodesTable loaded',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }))));
};
exports.NodesList = NodesList;