"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobMemoryTreeMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _common = require("@kbn/field-formats-plugin/common");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _chartsTheme = require("@kbn/charts-theme");
var _loading_wrapper = require("../../jobs/new_job/pages/components/charts/loading_wrapper");
var _kibana = require("../../contexts/kibana");
var _memory_item_colors = require("../memory_item_colors");
var _toast_notification_service = require("../../services/toast_notification_service");
var _ml = require("../../contexts/ml");
var _use_memory_usage = require("../use_memory_usage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/memory_usage/memory_tree_map/tree_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_CHART_HEIGHT = '400px';
const TYPE_LABELS = {
  [_i18n.i18n.translate('xpack.ml.memoryUsage.treeMap.adLabel', {
    defaultMessage: 'Anomaly detection jobs'
  })]: 'anomaly-detector',
  [_i18n.i18n.translate('xpack.ml.memoryUsage.treeMap.dfaLabel', {
    defaultMessage: 'Data frame analytics jobs'
  })]: 'data-frame-analytics',
  [_i18n.i18n.translate('xpack.ml.memoryUsage.treeMap.modelsLabel', {
    defaultMessage: 'Trained models'
  })]: 'trained-model'
};
const TYPE_LABELS_INVERTED = Object.entries(TYPE_LABELS).reduce((acc, [label, type]) => {
  acc[type] = label;
  return acc;
}, {});
const JobMemoryTreeMap = ({
  node,
  type,
  height
}) => {
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _ml.useEnabledFeatures)();
  const bytesFormatter = (0, _kibana.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    loading,
    data: allData,
    error
  } = (0, _use_memory_usage.useMemoryUsage)(node, type);
  const chartHeight = height !== null && height !== void 0 ? height : DEFAULT_CHART_HEIGHT;
  const [data, setData] = (0, _react.useState)([]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(null);
  const typeOptions = (0, _react.useMemo)(() => {
    return Object.entries(TYPE_LABELS).filter(([, t]) => {
      if (t === 'anomaly-detector' && isADEnabled === false || t === 'data-frame-analytics' && isDFAEnabled === false || t === 'trained-model' && isNLPEnabled === false && isDFAEnabled === false) {
        return false;
      }
      return true;
    }).map(([label, t]) => ({
      label,
      color: (0, _memory_item_colors.getMemoryItemColor)(t)
    }));
  }, [isADEnabled, isDFAEnabled, isNLPEnabled]);
  (0, _react.useEffect)(function initSelectedOptions() {
    if (selectedOptions === null) {
      setSelectedOptions(typeOptions);
    }
  }, [selectedOptions, typeOptions]);
  const filterData = (0, _react.useCallback)(dataIn => {
    if (selectedOptions === null) {
      return dataIn;
    }
    const types = selectedOptions.map(o => TYPE_LABELS[o.label]);
    return dataIn.filter(d => types.includes(d.type));
  }, [selectedOptions]);
  (0, _react.useEffect)(function handleError() {
    if (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.memoryUsage.treeMap.fetchFailedErrorMessage', {
        defaultMessage: 'Error loading model memory usage data'
      }));
    }
  }, [error, displayErrorToast]);
  (0, _react.useEffect)(function redrawOnFilterChange() {
    setData(filterData(allData));
  }, [selectedOptions, allData, filterData]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: chartHeight
    },
    "data-test-subj": `mlJobTreeMap ${data.length ? 'withData' : 'empty'}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_loading_wrapper.LoadingWrapper, {
    height: chartHeight,
    hasData: data.length > 0,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    options: typeOptions,
    selectedOptions: selectedOptions !== null && selectedOptions !== void 0 ? selectedOptions : [],
    onChange: setSelectedOptions,
    "data-test-subj": "mlJobTreeMapComboBox",
    "aria-label": _i18n.i18n.translate('xpack.ml.memoryUsage.treeMap.typeFilterAriaLabel', {
      defaultMessage: 'Job or model type'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), data.length ? /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "memoryUsageTreeMap",
    data: data,
    layout: _charts.PartitionLayout.treemap,
    valueAccessor: d => d.size,
    valueFormatter: size => bytesFormatter(size),
    layers: [{
      groupByRollup: d => d.type,
      nodeLabel: d => TYPE_LABELS_INVERTED[d],
      fillLabel: {
        valueFormatter: size => bytesFormatter(size)
      },
      shape: {
        fillColor: dataName => (0, _memory_item_colors.getMemoryItemColor)(dataName)
      }
    }, {
      groupByRollup: d => d.id,
      nodeLabel: d => `${d}`,
      fillLabel: {
        valueFont: {
          fontWeight: 100
        }
      },
      shape: {
        fillColor: (dataName, index, d) => {
          // color the shape the same as its parent.
          const parentId = d.parent.path[d.parent.path.length - 1].value;
          return (0, _memory_item_colors.getMemoryItemColor)(parentId);
        }
      }
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "xs",
    iconType: "warning",
    "data-test-subj": "mlEmptyMemoryUsageTreeMap",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.memoryUsage.treeMap.emptyPrompt",
      defaultMessage: "No open jobs or trained models match the current selection. ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  })));
};
exports.JobMemoryTreeMap = JobMemoryTreeMap;