"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fieldTypes = require("@kbn/field-types");
var _page_title = require("../../../../components/page_title");
var _kibana = require("../../../../contexts/kibana");
var _ml = require("../../../../contexts/ml");
var _data_recognizer = require("../../../../components/data_recognizer");
var _recently_accessed = require("../../../../util/recently_accessed");
var _link_card = require("../../../../components/link_card");
var _locator = require("../../../../../../common/constants/locator");
var _use_create_url = require("../../../../contexts/kibana/use_create_url");
var _page_header = require("../../../../components/page_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/job_type/page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Page = () => {
  var _selectedSavedSearch$, _selectedSavedSearch$2;
  const {
    services: {
      chrome: {
        recentlyAccessed
      },
      share,
      notifications: {
        toasts
      }
    }
  } = (0, _kibana.useMlKibana)();
  const dataSourceContext = (0, _ml.useDataSource)();
  const onSelectDifferentIndex = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX);
  const [recognizerResultsCount, setRecognizerResultsCount] = (0, _react.useState)(0);
  const {
    selectedDataView,
    selectedSavedSearch
  } = dataSourceContext;
  const isTimeBasedIndex = selectedDataView.isTimeBased();
  const mlManagementLocator = (0, _kibana.useMlManagementLocator)();
  const navigateToManagementPath = async path => {
    if (!mlManagementLocator) return;
    await mlManagementLocator.navigate({
      sectionId: 'ml',
      appId: `anomaly_detection${path}`
    });
  };
  (0, _react.useEffect)(() => {
    if (!isTimeBasedIndex) {
      toasts.addWarning({
        title: _i18n.i18n.translate('xpack.ml.dataViewNotBasedOnTimeSeriesNotificationTitle', {
          defaultMessage: 'The data view {dataViewIndexPattern} is not based on a time series',
          values: {
            dataViewIndexPattern: selectedDataView.getIndexPattern()
          }
        }),
        text: _i18n.i18n.translate('xpack.ml.dataViewNotBasedOnTimeSeriesNotificationDescription', {
          defaultMessage: 'Anomaly detection only runs over time-based indices'
        })
      });
    }
  }, [isTimeBasedIndex, selectedDataView, toasts]);
  const hasGeoFields = (0, _react.useMemo)(() => [...selectedDataView.fields.getByType(_fieldTypes.ES_FIELD_TYPES.GEO_POINT), ...selectedDataView.fields.getByType(_fieldTypes.ES_FIELD_TYPES.GEO_SHAPE)].length > 0, [selectedDataView]);
  const indexWarningTitle = !isTimeBasedIndex && selectedSavedSearch ? _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.dataViewFromSavedSearchNotTimeBasedMessage', {
    defaultMessage: '{savedSearchTitle} uses data view {dataViewName} which is not time based',
    values: {
      savedSearchTitle: (_selectedSavedSearch$ = selectedSavedSearch.title) !== null && _selectedSavedSearch$ !== void 0 ? _selectedSavedSearch$ : '',
      dataViewName: selectedDataView.getName()
    }
  }) : _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.dataViewNotTimeBasedMessage', {
    defaultMessage: 'Data view {dataViewName} is not time based',
    values: {
      dataViewName: selectedDataView.getName()
    }
  });
  const pageTitleLabel = selectedSavedSearch ? _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.savedSearchPageTitleLabel', {
    defaultMessage: 'Discover session {savedSearchTitle}',
    values: {
      savedSearchTitle: (_selectedSavedSearch$2 = selectedSavedSearch.title) !== null && _selectedSavedSearch$2 !== void 0 ? _selectedSavedSearch$2 : ''
    }
  }) : _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.dataViewPageTitleLabel', {
    defaultMessage: 'data view {dataViewName}',
    values: {
      dataViewName: selectedDataView.getName()
    }
  });
  const recognizerResults = {
    count: 0,
    onChange() {
      setRecognizerResultsCount(recognizerResults.count);
    }
  };
  const getUrlParams = () => {
    return !selectedSavedSearch ? `?index=${selectedDataView.id}` : `?savedSearchId=${selectedSavedSearch.id}`;
  };
  const addSelectionToRecentlyAccessed = async () => {
    var _selectedSavedSearch$3;
    const title = !selectedSavedSearch ? selectedDataView.getName() : (_selectedSavedSearch$3 = selectedSavedSearch.title) !== null && _selectedSavedSearch$3 !== void 0 ? _selectedSavedSearch$3 : '';
    const mlLocator = share.url.locators.get(_locator.ML_APP_LOCATOR);
    const dataVisualizerLink = await mlLocator.getUrl({
      page: _locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER,
      pageState: {
        ...(selectedSavedSearch !== null && selectedSavedSearch !== void 0 && selectedSavedSearch.id ? {
          savedSearchId: selectedSavedSearch.id
        } : {
          index: selectedDataView.id
        })
      }
    }, {
      absolute: true
    });
    (0, _recently_accessed.addItemToRecentlyAccessed)(_locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER, title, dataVisualizerLink, recentlyAccessed);
    navigateToManagementPath(`/jobs/new_job/datavisualizer${getUrlParams()}`);
  };
  const jobTypes = [{
    onClick: () => navigateToManagementPath(`/jobs/new_job/single_metric${getUrlParams()}`),
    icon: {
      type: 'createSingleMetricJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.singleMetricAriaLabel', {
        defaultMessage: 'Single metric job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.singleMetricTitle', {
      defaultMessage: 'Single metric'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.singleMetricDescription', {
      defaultMessage: 'Detect anomalies in a single time series.'
    }),
    id: 'mlJobTypeLinkSingleMetricJob'
  }, {
    onClick: () => navigateToManagementPath(`/jobs/new_job/multi_metric${getUrlParams()}`),
    icon: {
      type: 'createMultiMetricJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.multiMetricAriaLabel', {
        defaultMessage: 'Multi-metric job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.multiMetricTitle', {
      defaultMessage: 'Multi-metric'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.multiMetricDescription', {
      defaultMessage: 'Detect anomalies with one or more metrics and optionally split the analysis.'
    }),
    id: 'mlJobTypeLinkMultiMetricJob'
  }, {
    onClick: () => navigateToManagementPath(`/jobs/new_job/population${getUrlParams()}`),
    icon: {
      type: 'createPopulationJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.populationAriaLabel', {
        defaultMessage: 'Population job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.populationTitle', {
      defaultMessage: 'Population'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.populationDescription', {
      defaultMessage: 'Detect unusual activity in a population. Recommended for high cardinality data.'
    }),
    id: 'mlJobTypeLinkPopulationJob'
  }, {
    onClick: () => navigateToManagementPath(`/jobs/new_job/advanced${getUrlParams()}`),
    icon: {
      type: 'createAdvancedJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.advancedAriaLabel', {
        defaultMessage: 'Advanced job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.advancedTitle', {
      defaultMessage: 'Advanced'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.advancedDescription', {
      defaultMessage: 'Use the full range of options to create a job for more advanced use cases.'
    }),
    id: 'mlJobTypeLinkAdvancedJob'
  }, {
    onClick: () => navigateToManagementPath(`/jobs/new_job/categorization${getUrlParams()}`),
    icon: {
      type: 'createGenericJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.categorizationAriaLabel', {
        defaultMessage: 'Categorization job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.categorizationTitle', {
      defaultMessage: 'Categorization'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.categorizationDescription', {
      defaultMessage: 'Group log messages into categories and detect anomalies within them.'
    }),
    id: 'mlJobTypeLinkCategorizationJob'
  }, {
    onClick: () => navigateToManagementPath(`/jobs/new_job/rare${getUrlParams()}`),
    icon: {
      type: 'createGenericJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.rareAriaLabel', {
        defaultMessage: 'Rare job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.rareTitle', {
      defaultMessage: 'Rare'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.rareDescription', {
      defaultMessage: 'Detect rare values in time series data.'
    }),
    id: 'mlJobTypeLinkrareJob'
  }];
  if (hasGeoFields) {
    jobTypes.push({
      onClick: () => navigateToManagementPath(`/jobs/new_job/geo${getUrlParams()}`),
      icon: {
        type: 'createGeoJob',
        ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.geoAriaLabel', {
          defaultMessage: 'Geo job'
        })
      },
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.geoTitle', {
        defaultMessage: 'Geo'
      }),
      description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.geoDescription', {
        defaultMessage: 'Detect anomalies in the geographic location of the data.'
      }),
      id: 'mlJobTypeLinkGeoJob'
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageJobTypeSelection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobType.createJobFromTitle",
      defaultMessage: "Create a job from the {pageTitleLabel}",
      values: {
        pageTitleLabel
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 9
    }
  })), isTimeBasedIndex === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: indexWarningTitle,
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.howToRunAnomalyDetectionDescription",
    defaultMessage: "Anomaly detection can only be run over indices which are time based.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onSelectDifferentIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.selectDifferentIndexLinkText",
    defaultMessage: "Select a different data view or saved Discover session",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    hidden: recognizerResultsCount === 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.useSuppliedConfigurationTitle",
    defaultMessage: "Use preconfigured jobs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.useSuppliedConfigurationDescription",
    defaultMessage: "The fields in your data match known configurations. Create a set of preconfigured jobs.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_data_recognizer.DataRecognizer, {
    indexPattern: selectedDataView,
    savedSearch: selectedSavedSearch,
    results: recognizerResults,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.useWizardTitle",
    defaultMessage: "Use a wizard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 7
    }
  }, jobTypes.map(({
    onClick,
    icon,
    title,
    description,
    id
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_link_card.LinkCard, {
    "data-test-subj": id,
    onClick: onClick,
    icon: icon.type,
    iconAreaLabel: icon.ariaLabel,
    title: title,
    description: description,
    isDisabled: !isTimeBasedIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.learnMoreAboutDataTitle",
    defaultMessage: "Learn more about your data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.learnMoreAboutDataDescription",
    defaultMessage: "If you're not sure what type of job to create, first explore the fields and metrics in your data.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_link_card.LinkCard, {
    icon: "dataVisualizer",
    iconAreaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.dataVisualizerAriaLabel', {
      defaultMessage: 'Data Visualizer'
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobType.dataVisualizerTitle",
      defaultMessage: "Data Visualizer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 400,
        columnNumber: 15
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobType.dataVisualizerDescription",
      defaultMessage: "Learn more about the characteristics of your data and identify the fields for analysis with machine learning.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 406,
        columnNumber: 15
      }
    }),
    onClick: addSelectionToRecentlyAccessed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 11
    }
  }))));
};
exports.Page = Page;