"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareView = exports.RARE_DETECTOR_TYPE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _metric_selection = require("./metric_selection");
var _metric_selection_summary = require("./metric_selection_summary");
var _settings = require("./settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/rare_view/rare_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let RARE_DETECTOR_TYPE = exports.RARE_DETECTOR_TYPE = /*#__PURE__*/function (RARE_DETECTOR_TYPE) {
  RARE_DETECTOR_TYPE[RARE_DETECTOR_TYPE["RARE"] = 0] = "RARE";
  RARE_DETECTOR_TYPE[RARE_DETECTOR_TYPE["RARE_POPULATION"] = 1] = "RARE_POPULATION";
  RARE_DETECTOR_TYPE[RARE_DETECTOR_TYPE["FREQ_RARE_POPULATION"] = 2] = "FREQ_RARE_POPULATION";
  return RARE_DETECTOR_TYPE;
}({});
const RareView = ({
  isActive,
  setCanProceed
}) => {
  const [rareFieldValid, setRareFieldValid] = (0, _react.useState)(false);
  const [settingsValid, setSettingsValid] = (0, _react.useState)(false);
  const [rareDetectorType, setRareDetectorType] = (0, _react.useState)(RARE_DETECTOR_TYPE.RARE);
  (0, _react.useEffect)(() => {
    if (typeof setCanProceed === 'function') {
      setCanProceed(rareFieldValid && settingsValid);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [rareFieldValid, settingsValid]);
  return isActive === false ? /*#__PURE__*/_react.default.createElement(_metric_selection_summary.RareDetectorsSummary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metric_selection.RareDetectors, {
    setIsValid: setRareFieldValid,
    rareDetectorType: rareDetectorType,
    setRareDetectorType: setRareDetectorType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), rareFieldValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_settings.RareSettings, {
    setIsValid: setSettingsValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  })));
};
exports.RareView = RareView;