"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopCategories = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../../../../../../contexts/kibana");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _job_creator_context = require("../../../job_creator_context");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/categorization_view/top_categories.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopCategories = () => {
  const mlApi = (0, _kibana.useMlApi)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    jobCreator: jc,
    resultsLoader
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [tableRow, setTableRow] = (0, _react.useState)([]);
  const [totalCategories, setTotalCategories] = (0, _react.useState)(0);
  function setResultsWrapper(results) {
    loadTopCats();
  }
  async function loadTopCats() {
    try {
      const results = await mlApi.jobs.topCategories(jobCreator.jobId, _new_job.NUMBER_OF_CATEGORY_EXAMPLES);
      setTableRow(results.categories.map(c => {
        var _c$category$examples;
        return {
          count: c.count,
          example: (_c$category$examples = c.category.examples) !== null && _c$category$examples !== void 0 && _c$category$examples.length ? c.category.examples[0] : ''
        };
      }));
      setTotalCategories(results.total);
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorProperties)(e);
      // might get 404 because job has not been created yet
      if (error.statusCode !== 404) {
        displayErrorToast(e);
      }
    }
  }
  (0, _react.useEffect)(() => {
    // subscribe to result updates
    const resultsSubscription = resultsLoader.subscribeToResults(setResultsWrapper);
    return () => {
      resultsSubscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const columns = [
  // only include counts if model plot is enabled
  ...(jobCreator.modelPlot ? [{
    field: 'count',
    name: 'count',
    width: '100px',
    render: count => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 17
      }
    }, count))
  }] : []), {
    field: 'example',
    name: 'Example',
    render: example => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }, example))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, totalCategories > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationTotalCategories",
    defaultMessage: "Total categories: {totalCategories}",
    values: {
      totalCategories
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: tableRow,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  })));
};
exports.TopCategories = TopCategories;