"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationPerPartitionFieldDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_creator_context = require("../../../job_creator_context");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _categorization_per_partition_input = require("./categorization_per_partition_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/categorization_partition_field/categorization_per_partition_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CategorizationPerPartitionFieldDropdown = ({
  setEnablePerPartitionCategorization
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [categorizationPartitionFieldName, setCategorizationPartitionFieldName] = (0, _react.useState)(jobCreator.categorizationPerPartitionField);
  const {
    categoryFields
  } = (0, _new_job_capabilities_service.useNewJobCapsService)();
  const filteredCategories = (0, _react.useMemo)(() => categoryFields.filter(c => c.id !== jobCreator.categorizationFieldName),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [categoryFields, jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    jobCreator.categorizationPerPartitionField = categorizationPartitionFieldName;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [categorizationPartitionFieldName]);
  (0, _react.useEffect)(() => {
    // set the first item in category as partition field by default
    // because API requires partition_field to be defined in each detector with mlcategory
    // if per-partition categorization is enabled
    if (jobCreator.perPartitionCategorization && jobCreator.categorizationPerPartitionField === null && filteredCategories.length > 0) {
      jobCreator.categorizationPerPartitionField = filteredCategories[0].id;
    }
    setCategorizationPartitionFieldName(jobCreator.categorizationPerPartitionField);
    setEnablePerPartitionCategorization(jobCreator.perPartitionCategorization);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.extraStep.categorizationJob.categorizationPerPartitionFieldLabel",
      defaultMessage: "Partition field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_categorization_per_partition_input.CategorizationPerPartitionFieldSelect, {
    fields: filteredCategories,
    changeHandler: setCategorizationPartitionFieldName,
    selectedField: categorizationPartitionFieldName || '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
exports.CategorizationPerPartitionFieldDropdown = CategorizationPerPartitionFieldDropdown;